/*
 * $Id: suite.c,v 1.5 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: suite.c,v $
 * Revision 1.5  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.4  1999/01/29 21:37:14  malte
 * replaced machine specific tests with ENDIAN macro
 *
 * Revision 1.3  1994/02/19 11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>

#include "dea.h"

#define	KEYCOL		0
#define	TEXTCOL		1
#define	CIPHCOL		2

static	deablk	patterson[3] = {
	{ 0x00000000, 0x00000000 }, { 0x00000000, 0x00000000 }, { 0x2461029B, 0x5988CFB4 }
};

/*
 * From: keith.willis@almac.co.uk
 * Newsgroups: sci.crypt
 * Subject: des validation 1/2
 * Message-ID: <1992Jul17.864.235@ALMAC>
 * Date: 17 Jul 92 18:30:55 GMT
 * 
 * 
 *         If anyone is interested, here is a reasonable sized DES
 *         validation set.  Col 1 is the key, col 2 is the plaintext,
 *         and col 3 is the expected ciphertext.
 * 
 */
static	deablk	willis[][3] = {
{{ 0x00000000, 0x00000000 }, { 0x00000000, 0x00000000 }, { 0x8CA64DE9, 0xC1B123A7 }},
{{ 0x00000000, 0x00000000 }, { 0xFFFFFFFF, 0xFFFFFFFF }, { 0x355550B2, 0x150E2451 }},
{{ 0x01010101, 0x01010101 }, { 0x01234567, 0x89ABCDEF }, { 0x617B3A0C, 0xE8F07100 }},
{{ 0x01010101, 0x01010101 }, { 0x06E7EA22, 0xCE92708F }, { 0x00000000, 0x00000002 }},
{{ 0x01010101, 0x01010101 }, { 0x0953E225, 0x8E8E90A1 }, { 0x00000000, 0x00000020 }},
{{ 0x01010101, 0x01010101 }, { 0x0D9F279B, 0xA5D87260 }, { 0x01000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x1029D55E, 0x880EC2D0 }, { 0x00000000, 0x00008000 }},
{{ 0x01010101, 0x01010101 }, { 0x12A9F581, 0x7FF2D65D }, { 0x00000400, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x166B40B4, 0x4ABA4BD6 }, { 0x00000000, 0x00000001 }},
{{ 0x01010101, 0x01010101 }, { 0x1D1CA853, 0xAE7C0C5F }, { 0x00000000, 0x00002000 }},
{{ 0x01010101, 0x01010101 }, { 0x20B9E767, 0xB2FB1456 }, { 0x08000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x25EB5FC3, 0xF8CF0621 }, { 0x00000000, 0x00800000 }},
{{ 0x01010101, 0x01010101 }, { 0x2B9F982F, 0x20037FA9 }, { 0x00008000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x2E865310, 0x4F3834EA }, { 0x20000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x2FBC291A, 0x570DB5C4 }, { 0x00000000, 0x00000080 }},
{{ 0x01010101, 0x01010101 }, { 0x329A8ED5, 0x23D71AEC }, { 0x00001000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x424250B3, 0x7C3DD951 }, { 0x00400000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x48221B99, 0x37748A23 }, { 0x00000000, 0x00000200 }},
{{ 0x01010101, 0x01010101 }, { 0x4BD388FF, 0x6CD81D4F }, { 0x10000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x4D49DB15, 0x32919C9F }, { 0x00000000, 0x01000000 }},
{{ 0x01010101, 0x01010101 }, { 0x55579380, 0xD77138EF }, { 0x04000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x5B711BC4, 0xCEEBF2EE }, { 0x00000000, 0x00000010 }},
{{ 0x01010101, 0x01010101 }, { 0x5D86CB23, 0x639DBEA9 }, { 0x00000000, 0x00004000 }},
{{ 0x01010101, 0x01010101 }, { 0x5E090551, 0x7BB59BCF }, { 0x00000000, 0x04000000 }},
{{ 0x01010101, 0x01010101 }, { 0x64FEED9C, 0x724C2FAF }, { 0x00000040, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x6CC5DEFA, 0xAF04512F }, { 0x02000000, 0x00000000 }},       
{{ 0x01010101, 0x01010101 }, { 0x750D0794, 0x07521363 }, { 0x00000080, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x79E90DBC, 0x98F92CCA }, { 0x00000000, 0x00200000 }},
{{ 0x01010101, 0x01010101 }, { 0x814EEB3B, 0x91D90726 }, { 0x00000000, 0x02000000 }},
{{ 0x01010101, 0x01010101 }, { 0x8405D1AB, 0xE24FB942 }, { 0x00000000, 0x00000800 }},
{{ 0x01010101, 0x01010101 }, { 0x866ECEDD, 0x8072BB0E }, { 0x00000000, 0x00100000 }},
{{ 0x01010101, 0x01010101 }, { 0x889DE068, 0xA16F0BE6 }, { 0x00004000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x8B54536F, 0x2F3E64A8 }, { 0x00000000, 0x00080000 }},
{{ 0x01010101, 0x01010101 }, { 0x8DD45A2D, 0xDF90796C }, { 0x00000000, 0x00010000 }},
{{ 0x01010101, 0x01010101 }, { 0x95F8A5E5, 0xDD31D900 }, { 0x80000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x9D64555A, 0x9A10B852 }, { 0x00000010, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xA484C3AD, 0x38DC9C19 }, { 0x00000200, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xAB6A20C0, 0x620D1C6F }, { 0x00000000, 0x00400000 }},
{{ 0x01010101, 0x01010101 }, { 0xADD0CC8D, 0x6E5DEBA1 }, { 0x00080000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xAEB5F5ED, 0xE22D1A36 }, { 0x00000001, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xB160E468, 0x0F6C696F }, { 0x00000000, 0x20000000 }},
{{ 0x01010101, 0x01010101 }, { 0xB8061B7E, 0xCD9A21E5 }, { 0x00200000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xCA3A2B03, 0x6DBC8502 }, { 0x00000000, 0x08000000 }},
{{ 0x01010101, 0x01010101 }, { 0xCAFFC6AC, 0x4542DE31 }, { 0x00000000, 0x00020000 }},
{{ 0x01010101, 0x01010101 }, { 0xCC083F1E, 0x6D9E85F6 }, { 0x00000000, 0x00000008 }},
{{ 0x01010101, 0x01010101 }, { 0xCE332329, 0x248F3228 }, { 0x00000000, 0x00001000 }},
{{ 0x01010101, 0x01010101 }, { 0xD106FF0B, 0xED5255D7 }, { 0x00000008, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xD2FD8867, 0xD50D2DFE }, { 0x00000000, 0x00000004 }},
{{ 0x01010101, 0x01010101 }, { 0xD9031B02, 0x71BD5A0A }, { 0x00800000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xDD7C0BBD, 0x61FAFD54 }, { 0x00000000, 0x00000100 }},
{{ 0x01010101, 0x01010101 }, { 0xDD7F121C, 0xA5015619 }, { 0x40000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xDF98C827, 0x6F54B04B }, { 0x00000000, 0x40000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE07C30D7, 0xE4E26E12 }, { 0x00000000, 0x00000040 }},
{{ 0x01010101, 0x01010101 }, { 0xE1652C6B, 0x138C64A5 }, { 0x00000004, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE19E275D, 0x846A1298 }, { 0x00002000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE4285811, 0x86EC8F46 }, { 0x00000002, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE643D780, 0x90CA4207 }, { 0x00000000, 0x00000400 }},
{{ 0x01010101, 0x01010101 }, { 0xE6D5F827, 0x52AD63D1 }, { 0x00040000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE7FCE225, 0x57D23C97 }, { 0x00000800, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE943D756, 0x8AEC0C5C }, { 0x00000000, 0x80000000 }},
{{ 0x01010101, 0x01010101 }, { 0xEA51D397, 0x5595B86B }, { 0x00000000, 0x00040000 }},
{{ 0x01010101, 0x01010101 }, { 0xECBFE3BD, 0x3F591A5E }, { 0x00020000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF02B263B, 0x328E2B60 }, { 0x00000020, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF15D0F28, 0x6B65BD28 }, { 0x00100000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF3568343, 0x79D165CD }, { 0x00010000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xFA0752B0, 0x7D9C4AB8 }, { 0x00000000, 0x10000000 }},
{{ 0x01010101, 0x01010101 }, { 0xFBE00A8A, 0x1EF8AD72 }, { 0x00000100, 0x00000000 }},
{{ 0x01010101, 0x01010102 }, { 0x00000000, 0x00000000 }, { 0x869EFD7F, 0x9F265A09 }},
{{ 0x01010101, 0x01010104 }, { 0x00000000, 0x00000000 }, { 0xFCDB3291, 0xDE21F0C0 }},
{{ 0x01010101, 0x01010108 }, { 0x00000000, 0x00000000 }, { 0x5A594528, 0xBEBEF1CC }},
{{ 0x01010101, 0x01010110 }, { 0x00000000, 0x00000000 }, { 0x0875041E, 0x64C570F7 }},
{{ 0x01010101, 0x01010120 }, { 0x00000000, 0x00000000 }, { 0xA1AB2190, 0x545B91D7 }},
{{ 0x01010101, 0x01010140 }, { 0x00000000, 0x00000000 }, { 0xD863DBB5, 0xC59A91A0 }},
{{ 0x01010101, 0x01010180 }, { 0x00000000, 0x00000000 }, { 0x9CC62DF4, 0x3B6EED74 }},
{{ 0x01010101, 0x01010201 }, { 0x00000000, 0x00000000 }, { 0xAE8E5CAA, 0x3CA04E85 }},
{{ 0x01010101, 0x01010401 }, { 0x00000000, 0x00000000 }, { 0xB7FC92F9, 0x1D8E92E9 }},
{{ 0x01010101, 0x01010801 }, { 0x00000000, 0x00000000 }, { 0xDA99DBBC, 0x9A03F379 }},
{{ 0x01010101, 0x01011001 }, { 0x00000000, 0x00000000 }, { 0xE941A33F, 0x85501303 }},
{{ 0x01010101, 0x01012001 }, { 0x00000000, 0x00000000 }, { 0x1DE5279D, 0xAE3BED6F }},
{{ 0x01010101, 0x01014001 }, { 0x00000000, 0x00000000 }, { 0x14C1D7C1, 0xCFFEC79E }},
{{ 0x01010101, 0x01018001 }, { 0x00000000, 0x00000000 }, { 0xD1399712, 0xF99BF02E }},
{{ 0x01010101, 0x01020101 }, { 0x00000000, 0x00000000 }, { 0x024D1FFA, 0x8904E389 }},
{{ 0x01010101, 0x01040101 }, { 0x00000000, 0x00000000 }, { 0xAE13DBD5, 0x61488933 }},
{{ 0x01010101, 0x01080101 }, { 0x00000000, 0x00000000 }, { 0x5495C6AB, 0xF1E5DF51 }},
{{ 0x01010101, 0x01100101 }, { 0x00000000, 0x00000000 }, { 0x29038D56, 0xBA6D2745 }},
{{ 0x01010101, 0x01200101 }, { 0x00000000, 0x00000000 }, { 0x7A9BE42F, 0x2009A892 }},
{{ 0x01010101, 0x01400101 }, { 0x00000000, 0x00000000 }, { 0x41B9A79A, 0xF79AC208 }},
{{ 0x01010101, 0x01800101 }, { 0x00000000, 0x00000000 }, { 0x8638809E, 0x878787A0 }},
{{ 0x01010101, 0x02010101 }, { 0x00000000, 0x00000000 }, { 0x55705308, 0x29705592 }},
{{ 0x01010101, 0x04010101 }, { 0x00000000, 0x00000000 }, { 0x93C9B640, 0x42EAA240 }},
{{ 0x01010101, 0x08010101 }, { 0x00000000, 0x00000000 }, { 0x8181B65B, 0xABF4A975 }},
{{ 0x01010101, 0x10010101 }, { 0x00000000, 0x00000000 }, { 0x9DB73B3C, 0x0D163F54 }},
{{ 0x01010101, 0x20010101 }, { 0x00000000, 0x00000000 }, { 0xB7265F7F, 0x447AC6F3 }},
{{ 0x01010101, 0x40010101 }, { 0x00000000, 0x00000000 }, { 0x3CFAA7A7, 0xDC8720DC }},
{{ 0x01010101, 0x80010101 }, { 0x00000000, 0x00000000 }, { 0x19D032E6, 0x4AB0BD8B }},
{{ 0x01010102, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xB3C1CC71, 0x5CB879D8 }},
{{ 0x01010104, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x1AFA9A66, 0xA6DF92AE }},
{{ 0x01010108, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x4F644C92, 0xE192DFED }},
{{ 0x01010110, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA81FBD44, 0x8F9E522F }},
{{ 0x01010120, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xEE371483, 0x714C02EA }},
{{ 0x01010140, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC22F0A29, 0x4A71F29F }},
{{ 0x01010180, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x5199C29A, 0x52C9F059 }},
{{ 0x01010201, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC71516C2, 0x9C75D170 }},
{{ 0x01010401, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x25610288, 0x924511C2 }},
{{ 0x01010801, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x882BFF0A, 0xA01A0B87 }},
{{ 0x01011001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xCE7A24F3, 0x50E280B6 }},
{{ 0x01012001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x90BA680B, 0x22AEB525 }},
{{ 0x01014001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xCAC09F79, 0x7D031287 }},
{{ 0x01018001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA2DC9E92, 0xFD3CDE92 }},
{{ 0x01020101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA8468EE3, 0xBC18F06D }},
{{ 0x01040101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x50F63632, 0x4A9B7F80 }},
{{ 0x01079104, 0x91190101 }, { 0x00000000, 0x00000000 }, { 0xB4660481, 0x6C0E0774 }},
{{ 0x01079104, 0x91190401 }, { 0x00000000, 0x00000000 }, { 0x2DFA9F45, 0x73594965 }},
{{ 0x01079404, 0x91190401 }, { 0x00000000, 0x00000000 }, { 0x6E7E6221, 0xA4F34E87 }},
{{ 0x01080101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x178C83CE, 0x2B399D94 }},
{{ 0x01100101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xDFDD3CC6, 0x4DAE1642 }},
{{ 0x0113B970, 0xFD34F2CE }, { 0x059B5E08, 0x51CF143A }, { 0x86A560F1, 0x0EC6D85B }},
{{ 0x01200101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x31FE1736, 0x9B5288C9 }},
{{ 0x01234567, 0x89ABCDEF }, { 0x00000000, 0x00000000 }, { 0xD5D44FF7, 0x20683D0D }},
{{ 0x01234567, 0x89ABCDEF }, { 0x11111111, 0x11111111 }, { 0x17668DFC, 0x7292532D }},
{{ 0x0131D961, 0x9DC1376E }, { 0x5CD54CA8, 0x3DEF57DA }, { 0x7A389D10, 0x354BD271 }},
{{ 0x01400101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xDF3B99D6, 0x577397C8 }},
{{ 0x0170F175, 0x468FB5E6 }, { 0x0756D8E0, 0x774761D2 }, { 0x0CD3DA02, 0x0021DC09 }},
{{ 0x01800101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x20551233, 0x50C00858 }},
{{ 0x018310DC, 0x409B26D6 }, { 0x1D9D5C50, 0x18F728C2 }, { 0x5F4C038E, 0xD12B2E41 }},
{{ 0x02010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x4615AA1D, 0x33E72F10 }},
{{ 0x02581616, 0x4629B007 }, { 0x480D3900, 0x6EE762F2 }, { 0xA1F99155, 0x41020B56 }},
{{ 0x04010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC02FAFFE, 0xC989D1FC }},
{{ 0x04689104, 0xC2FD3B2F }, { 0x26955F68, 0x35AF609A }, { 0x5C513C9C, 0x4886C088 }},
{{ 0x04B915BA, 0x43FEB5B6 }, { 0x42FD4430, 0x59577FA2 }, { 0xAF37FB42, 0x1F8C4095 }},
{{ 0x07A1133E, 0x4A0B2686 }, { 0x0248D438, 0x06F67172 }, { 0x868EBB51, 0xCAB4599A }},
{{ 0x07A71370, 0x45DA2A16 }, { 0x3BDD1190, 0x49372802 }, { 0xDFD64A81, 0x5CAF1A0F }},
{{ 0x08010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x809F5F87, 0x3C1FD761 }},
{{ 0x10010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xD3746294, 0xCA6A6CF3 }},
{{ 0x10029115, 0x98100104 }, { 0x00000000, 0x00000000 }, { 0xB3E35A5E, 0xE53E7B8D }},
{{ 0x10029115, 0x98100201 }, { 0x00000000, 0x00000000 }, { 0xE2F5728F, 0x0995013C }},
{{ 0x10029115, 0x98190104 }, { 0x00000000, 0x00000000 }, { 0x61C79C71, 0x921A2EF8 }},
{{ 0x10029116, 0x98100101 }, { 0x00000000, 0x00000000 }, { 0x1AEAC39A, 0x61F0A464 }},
{{ 0x10048015, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0xABD88E8B, 0x1B7716F1 }},
{{ 0x10048015, 0x98190102 }, { 0x00000000, 0x00000000 }, { 0x537AC95B, 0xE69DA1E1 }},
{{ 0x10048015, 0x98190108 }, { 0x00000000, 0x00000000 }, { 0xAED0F6AE, 0x3C25CDD8 }},
{{ 0x10071034, 0x89988020 }, { 0x00000000, 0x00000000 }, { 0x0C0CC00C, 0x83EA48FD }},
{{ 0x10071034, 0xC8980120 }, { 0x00000000, 0x00000000 }, { 0x83BC8EF3, 0xA6570183 }},
{{ 0x10079115, 0x9819010B }, { 0x00000000, 0x00000000 }, { 0x05560581, 0x6E58608F }},
{{ 0x10079115, 0xB9080140 }, { 0x00000000, 0x00000000 }, { 0x00B588BE, 0x70D23F56 }},
{{ 0x10079119, 0x98190801 }, { 0x00000000, 0x00000000 }, { 0x2E5A19DB, 0x4D1962D6 }},
{{ 0x10079119, 0x981A0801 }, { 0x00000000, 0x00000000 }, { 0x23A866A8, 0x09D30894 }},
{{ 0x10079210, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0xD812D961, 0xF017D320 }},
{{ 0x10079404, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0x4D102196, 0xC914CA16 }},
{{ 0x1007B015, 0x19190101 }, { 0x00000000, 0x00000000 }, { 0xC9F00FFC, 0x74079067 }},
{{ 0x1007D015, 0x89980101 }, { 0x00000000, 0x00000000 }, { 0x6CB77361, 0x1DCA9ADA }},
{{ 0x1007D015, 0x98980120 }, { 0x00000000, 0x00000000 }, { 0xA6B7FF68, 0xA318DDD3 }},
{{ 0x10461034, 0x89988020 }, { 0x00000000, 0x00000000 }, { 0xDF725DCA, 0xD94EA2E9 }},
{{ 0x10469134, 0x89980131 }, { 0x00000000, 0x00000000 }, { 0x88D55E54, 0xF54C97B4 }},
{{ 0x10869115, 0x19190101 }, { 0x00000000, 0x00000000 }, { 0xE652B53B, 0x550BE8B0 }},
{{ 0x10869115, 0x19580101 }, { 0x00000000, 0x00000000 }, { 0xAF527120, 0xC485CBB0 }},
{{ 0x11111111, 0x11111111 }, { 0x01234567, 0x89ABCDEF }, { 0x8A5AE1F8, 0x1AB8F2DD }},
{{ 0x11111111, 0x11111111 }, { 0x11111111, 0x11111111 }, { 0xF40379AB, 0x9E0EC533 }},
{{ 0x19079210, 0x981A0101 }, { 0x00000000, 0x00000000 }, { 0xAA85E746, 0x43233199 }},
{{ 0x1C587F1C, 0x13924FEF }, { 0x30553228, 0x6D6F295A }, { 0x63FAC0D0, 0x34D9F793 }},
{{ 0x1C587F1C, 0x13924FEF }, { 0x30553228, 0x6D6F295A }, { 0x63FAC0D0, 0x34D9F793 }},
{{ 0x1F08260D, 0x1AC2465E }, { 0x6B056E18, 0x759F5CCA }, { 0xEF1BF03E, 0x5DFA575A }},
{{ 0x1F1F1F1F, 0x0E0E0E0E }, { 0x01234567, 0x89ABCDEF }, { 0xDB958605, 0xF8C8C606 }},
{{ 0x20010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x7AD16FFB, 0x79C45926 }},
{{ 0x30000000, 0x00000000 }, { 0x10000000, 0x00000001 }, { 0x958E6E62, 0x7A05557B }},
{{ 0x31079115, 0x98080140 }, { 0x00000000, 0x00000000 }, { 0x406A9A6A, 0xB43399AE }},
{{ 0x31079154, 0x98080101 }, { 0x00000000, 0x00000000 }, { 0x7CFD82A5, 0x93252B4E }},
{{ 0x31079194, 0x98080101 }, { 0x00000000, 0x00000000 }, { 0xCB49A2F9, 0xE91363E3 }},
{{ 0x37D06BB5, 0x16CB7546 }, { 0x164D5E40, 0x4F275232 }, { 0x0A2AEEAE, 0x3FF4AB77 }},
{{ 0x3849674C, 0x2602319E }, { 0x51454B58, 0x2DDF440A }, { 0x7178876E, 0x01F19B2A }},
{{ 0x40010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x0EEC1487, 0xDD8C26D5 }},
{{ 0x43297FAD, 0x38E373FE }, { 0x762514B8, 0x29BF486A }, { 0xEA676B2C, 0xB7DB2B7A }},
{{ 0x49793EBC, 0x79B3258F }, { 0x437540C8, 0x698F3CFA }, { 0x6FBF1CAF, 0xCFFD0556 }},
{{ 0x49E95D6D, 0x4CA229BF }, { 0x02FE5577, 0x8117F12A }, { 0x5A6B612C, 0xC26CCE4A }},
{{ 0x4FB05E15, 0x15AB73A7 }, { 0x072D43A0, 0x77075292 }, { 0x2F22E49B, 0xAB7CA1AC }},
{{ 0x5107B015, 0x19580101 }, { 0x00000000, 0x00000000 }, { 0x0F04CE39, 0x3DB926D5 }},
{{ 0x58402364, 0x1ABA6176 }, { 0x004BD6EF, 0x09176062 }, { 0x88BF0DB6, 0xD70DEE56 }},
{{ 0x7CA11045, 0x4A1A6E57 }, { 0x01A1D6D0, 0x39776742 }, { 0x690F5B0D, 0x9A26939B }},
{{ 0x80010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x95A8D728, 0x13DAA94D }},
{{ 0x91079115, 0x89980101 }, { 0x00000000, 0x00000000 }, { 0x67FD21C1, 0x7DBB5D70 }},
{{ 0x9107D015, 0x89190101 }, { 0x00000000, 0x00000000 }, { 0x9592CB41, 0x10430787 }},
{{ 0xE0FEE0FE, 0xF1FEF1FE }, { 0x01234567, 0x89ABCDEF }, { 0xEDBFD1C6, 0x6C29CCC7 }},
{{ 0xFEDCBA98, 0x76543210 }, { 0x01234567, 0x89ABCDEF }, { 0xED39D950, 0xFA74BCC4 }},
{{ 0xFEDCBA98, 0x76543210 }, { 0xFFFFFFFF, 0xFFFFFFFF }, { 0x2A2BB008, 0xDF97C2F2 }},
{{ 0xFFFFFFFF, 0xFFFFFFFF }, { 0x00000000, 0x00000000 }, { 0xCAAAAF4D, 0xEAF1DBAE }},
{{ 0xFFFFFFFF, 0xFFFFFFFF }, { 0xFFFFFFFF, 0xFFFFFFFF }, { 0x7359B216, 0x3E4EDC58 }}
};

/*
 * from koontz-des I believe
 */
static	deablk	encrypt[][3] = {
{{ 0x01010101, 0x01010101 }, { 0x95F8A5E5, 0xDD31D900 }, { 0x80000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xDD7F121C, 0xA5015619 }, { 0x40000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x2E865310, 0x4F3834EA }, { 0x20000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x4BD388FF, 0x6CD81D4F }, { 0x10000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x20B9E767, 0xB2FB1456 }, { 0x08000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x55579380, 0xD77138EF }, { 0x04000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x6CC5DEFA, 0xAF04512F }, { 0x02000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x0D9F279B, 0xA5D87260 }, { 0x01000000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xD9031B02, 0x71BD5A0A }, { 0x00800000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x424250B3, 0x7C3DD951 }, { 0x00400000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xB8061B7E, 0xCD9A21E5 }, { 0x00200000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF15D0F28, 0x6B65BD28 }, { 0x00100000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xADD0CC8D, 0x6E5DEBA1 }, { 0x00080000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE6D5F827, 0x52AD63D1 }, { 0x00040000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xECBFE3BD, 0x3F591A5E }, { 0x00020000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF3568343, 0x79D165CD }, { 0x00010000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x2B9F982F, 0x20037FA9 }, { 0x00008000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x889DE068, 0xA16F0BE6 }, { 0x00004000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE19E275D, 0x846A1298 }, { 0x00002000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x329A8ED5, 0x23D71AEC }, { 0x00001000, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE7FCE225, 0x57D23C97 }, { 0x00000800, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x12A9F581, 0x7FF2D65D }, { 0x00000400, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xA484C3AD, 0x38DC9C19 }, { 0x00000200, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xFBE00A8A, 0x1EF8AD72 }, { 0x00000100, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x750D0794, 0x07521363 }, { 0x00000080, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x64FEED9C, 0x724C2FAF }, { 0x00000040, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xF02B263B, 0x328E2B60 }, { 0x00000020, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0x9D64555A, 0x9A10B852 }, { 0x00000010, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xD106FF0B, 0xED5255D7 }, { 0x00000008, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE1652C6B, 0x138C64A5 }, { 0x00000004, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE4285811, 0x86EC8F46 }, { 0x00000002, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xAEB5F5ED, 0xE22D1A36 }, { 0x00000001, 0x00000000 }},
{{ 0x01010101, 0x01010101 }, { 0xE943D756, 0x8AEC0C5C }, { 0x00000000, 0x80000000 }},
{{ 0x01010101, 0x01010101 }, { 0xDF98C827, 0x6F54B04B }, { 0x00000000, 0x40000000 }},
{{ 0x01010101, 0x01010101 }, { 0xB160E468, 0x0F6C696F }, { 0x00000000, 0x20000000 }},
{{ 0x01010101, 0x01010101 }, { 0xFA0752B0, 0x7D9C4AB8 }, { 0x00000000, 0x10000000 }},
{{ 0x01010101, 0x01010101 }, { 0xCA3A2B03, 0x6DBC8502 }, { 0x00000000, 0x08000000 }},
{{ 0x01010101, 0x01010101 }, { 0x5E090551, 0x7BB59BCF }, { 0x00000000, 0x04000000 }},
{{ 0x01010101, 0x01010101 }, { 0x814EEB3B, 0x91D90726 }, { 0x00000000, 0x02000000 }},
{{ 0x01010101, 0x01010101 }, { 0x4D49DB15, 0x32919C9F }, { 0x00000000, 0x01000000 }},
{{ 0x01010101, 0x01010101 }, { 0x25EB5FC3, 0xF8CF0621 }, { 0x00000000, 0x00800000 }},
{{ 0x01010101, 0x01010101 }, { 0xAB6A20C0, 0x620D1C6F }, { 0x00000000, 0x00400000 }},
{{ 0x01010101, 0x01010101 }, { 0x79E90DBC, 0x98F92CCA }, { 0x00000000, 0x00200000 }},
{{ 0x01010101, 0x01010101 }, { 0x866ECEDD, 0x8072BB0E }, { 0x00000000, 0x00100000 }},
{{ 0x01010101, 0x01010101 }, { 0x8B54536F, 0x2F3E64A8 }, { 0x00000000, 0x00080000 }},
{{ 0x01010101, 0x01010101 }, { 0xEA51D397, 0x5595B86B }, { 0x00000000, 0x00040000 }},
{{ 0x01010101, 0x01010101 }, { 0xCAFFC6AC, 0x4542DE31 }, { 0x00000000, 0x00020000 }},
{{ 0x01010101, 0x01010101 }, { 0x8DD45A2D, 0xDF90796C }, { 0x00000000, 0x00010000 }},
{{ 0x01010101, 0x01010101 }, { 0x1029D55E, 0x880EC2D0 }, { 0x00000000, 0x00008000 }},
{{ 0x01010101, 0x01010101 }, { 0x5D86CB23, 0x639DBEA9 }, { 0x00000000, 0x00004000 }},
{{ 0x01010101, 0x01010101 }, { 0x1D1CA853, 0xAE7C0C5F }, { 0x00000000, 0x00002000 }},
{{ 0x01010101, 0x01010101 }, { 0xCE332329, 0x248F3228 }, { 0x00000000, 0x00001000 }},
{{ 0x01010101, 0x01010101 }, { 0x8405D1AB, 0xE24FB942 }, { 0x00000000, 0x00000800 }},
{{ 0x01010101, 0x01010101 }, { 0xE643D780, 0x90CA4207 }, { 0x00000000, 0x00000400 }},
{{ 0x01010101, 0x01010101 }, { 0x48221B99, 0x37748A23 }, { 0x00000000, 0x00000200 }},
{{ 0x01010101, 0x01010101 }, { 0xDD7C0BBD, 0x61FAFD54 }, { 0x00000000, 0x00000100 }},
{{ 0x01010101, 0x01010101 }, { 0x2FBC291A, 0x570DB5C4 }, { 0x00000000, 0x00000080 }},
{{ 0x01010101, 0x01010101 }, { 0xE07C30D7, 0xE4E26E12 }, { 0x00000000, 0x00000040 }},
{{ 0x01010101, 0x01010101 }, { 0x0953E225, 0x8E8E90A1 }, { 0x00000000, 0x00000020 }},
{{ 0x01010101, 0x01010101 }, { 0x5B711BC4, 0xCEEBF2EE }, { 0x00000000, 0x00000010 }},
{{ 0x01010101, 0x01010101 }, { 0xCC083F1E, 0x6D9E85F6 }, { 0x00000000, 0x00000008 }},
{{ 0x01010101, 0x01010101 }, { 0xD2FD8867, 0xD50D2DFE }, { 0x00000000, 0x00000004 }},
{{ 0x01010101, 0x01010101 }, { 0x06E7EA22, 0xCE92708F }, { 0x00000000, 0x00000002 }},
{{ 0x01010101, 0x01010101 }, { 0x166B40B4, 0x4ABA4BD6 }, { 0x00000000, 0x00000001 }},
{{ 0x01010101, 0x01010101 }, { 0x80000000, 0x00000000 }, { 0x95F8A5E5, 0xDD31D900 }},
{{ 0x01010101, 0x01010101 }, { 0x40000000, 0x00000000 }, { 0xDD7F121C, 0xA5015619 }},
{{ 0x01010101, 0x01010101 }, { 0x20000000, 0x00000000 }, { 0x2E865310, 0x4F3834EA }},
{{ 0x01010101, 0x01010101 }, { 0x10000000, 0x00000000 }, { 0x4BD388FF, 0x6CD81D4F }},
{{ 0x01010101, 0x01010101 }, { 0x08000000, 0x00000000 }, { 0x20B9E767, 0xB2FB1456 }},
{{ 0x01010101, 0x01010101 }, { 0x04000000, 0x00000000 }, { 0x55579380, 0xD77138EF }},
{{ 0x01010101, 0x01010101 }, { 0x02000000, 0x00000000 }, { 0x6CC5DEFA, 0xAF04512F }},
{{ 0x01010101, 0x01010101 }, { 0x01000000, 0x00000000 }, { 0x0D9F279B, 0xA5D87260 }},
{{ 0x01010101, 0x01010101 }, { 0x00800000, 0x00000000 }, { 0xD9031B02, 0x71BD5A0A }},
{{ 0x01010101, 0x01010101 }, { 0x00400000, 0x00000000 }, { 0x424250B3, 0x7C3DD951 }},
{{ 0x01010101, 0x01010101 }, { 0x00200000, 0x00000000 }, { 0xB8061B7E, 0xCD9A21E5 }},
{{ 0x01010101, 0x01010101 }, { 0x00100000, 0x00000000 }, { 0xF15D0F28, 0x6B65BD28 }},
{{ 0x01010101, 0x01010101 }, { 0x00080000, 0x00000000 }, { 0xADD0CC8D, 0x6E5DEBA1 }},
{{ 0x01010101, 0x01010101 }, { 0x00040000, 0x00000000 }, { 0xE6D5F827, 0x52AD63D1 }},
{{ 0x01010101, 0x01010101 }, { 0x00020000, 0x00000000 }, { 0xECBFE3BD, 0x3F591A5E }},
{{ 0x01010101, 0x01010101 }, { 0x00010000, 0x00000000 }, { 0xF3568343, 0x79D165CD }},
{{ 0x01010101, 0x01010101 }, { 0x00008000, 0x00000000 }, { 0x2B9F982F, 0x20037FA9 }},
{{ 0x01010101, 0x01010101 }, { 0x00004000, 0x00000000 }, { 0x889DE068, 0xA16F0BE6 }},
{{ 0x01010101, 0x01010101 }, { 0x00002000, 0x00000000 }, { 0xE19E275D, 0x846A1298 }},
{{ 0x01010101, 0x01010101 }, { 0x00001000, 0x00000000 }, { 0x329A8ED5, 0x23D71AEC }},
{{ 0x01010101, 0x01010101 }, { 0x00000800, 0x00000000 }, { 0xE7FCE225, 0x57D23C97 }},
{{ 0x01010101, 0x01010101 }, { 0x00000400, 0x00000000 }, { 0x12A9F581, 0x7FF2D65D }},
{{ 0x01010101, 0x01010101 }, { 0x00000200, 0x00000000 }, { 0xA484C3AD, 0x38DC9C19 }},
{{ 0x01010101, 0x01010101 }, { 0x00000100, 0x00000000 }, { 0xFBE00A8A, 0x1EF8AD72 }},
{{ 0x01010101, 0x01010101 }, { 0x00000080, 0x00000000 }, { 0x750D0794, 0x07521363 }},
{{ 0x01010101, 0x01010101 }, { 0x00000040, 0x00000000 }, { 0x64FEED9C, 0x724C2FAF }},
{{ 0x01010101, 0x01010101 }, { 0x00000020, 0x00000000 }, { 0xF02B263B, 0x328E2B60 }},
{{ 0x01010101, 0x01010101 }, { 0x00000010, 0x00000000 }, { 0x9D64555A, 0x9A10B852 }},
{{ 0x01010101, 0x01010101 }, { 0x00000008, 0x00000000 }, { 0xD106FF0B, 0xED5255D7 }},
{{ 0x01010101, 0x01010101 }, { 0x00000004, 0x00000000 }, { 0xE1652C6B, 0x138C64A5 }},
{{ 0x01010101, 0x01010101 }, { 0x00000002, 0x00000000 }, { 0xE4285811, 0x86EC8F46 }},
{{ 0x01010101, 0x01010101 }, { 0x00000001, 0x00000000 }, { 0xAEB5F5ED, 0xE22D1A36 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x80000000 }, { 0xE943D756, 0x8AEC0C5C }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x40000000 }, { 0xDF98C827, 0x6F54B04B }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x20000000 }, { 0xB160E468, 0x0F6C696F }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x10000000 }, { 0xFA0752B0, 0x7D9C4AB8 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x08000000 }, { 0xCA3A2B03, 0x6DBC8502 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x04000000 }, { 0x5E090551, 0x7BB59BCF }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x02000000 }, { 0x814EEB3B, 0x91D90726 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x01000000 }, { 0x4D49DB15, 0x32919C9F }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00800000 }, { 0x25EB5FC3, 0xF8CF0621 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00400000 }, { 0xAB6A20C0, 0x620D1C6F }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00200000 }, { 0x79E90DBC, 0x98F92CCA }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00100000 }, { 0x866ECEDD, 0x8072BB0E }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00080000 }, { 0x8B54536F, 0x2F3E64A8 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00040000 }, { 0xEA51D397, 0x5595B86B }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00020000 }, { 0xCAFFC6AC, 0x4542DE31 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00010000 }, { 0x8DD45A2D, 0xDF90796C }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00008000 }, { 0x1029D55E, 0x880EC2D0 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00004000 }, { 0x5D86CB23, 0x639DBEA9 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00002000 }, { 0x1D1CA853, 0xAE7C0C5F }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00001000 }, { 0xCE332329, 0x248F3228 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000800 }, { 0x8405D1AB, 0xE24FB942 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000400 }, { 0xE643D780, 0x90CA4207 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000200 }, { 0x48221B99, 0x37748A23 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000100 }, { 0xDD7C0BBD, 0x61FAFD54 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000080 }, { 0x2FBC291A, 0x570DB5C4 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000040 }, { 0xE07C30D7, 0xE4E26E12 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000020 }, { 0x0953E225, 0x8E8E90A1 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000010 }, { 0x5B711BC4, 0xCEEBF2EE }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000008 }, { 0xCC083F1E, 0x6D9E85F6 }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000004 }, { 0xD2FD8867, 0xD50D2DFE }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000002 }, { 0x06E7EA22, 0xCE92708F }},
{{ 0x01010101, 0x01010101 }, { 0x00000000, 0x00000001 }, { 0x166B40B4, 0x4ABA4BD6 }},
{{ 0x80010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x95A8D728, 0x13DAA94D }},
{{ 0x40010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x0EEC1487, 0xDD8C26D5 }},
{{ 0x20010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x7AD16FFB, 0x79C45926 }},
{{ 0x10010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xD3746294, 0xCA6A6CF3 }},
{{ 0x08010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x809F5F87, 0x3C1FD761 }},
{{ 0x04010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC02FAFFE, 0xC989D1FC }},
{{ 0x02010101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x4615AA1D, 0x33E72F10 }},
{{ 0x01800101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x20551233, 0x50C00858 }},
{{ 0x01400101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xDF3B99D6, 0x577397C8 }},
{{ 0x01200101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x31FE1736, 0x9B5288C9 }},
{{ 0x01100101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xDFDD3CC6, 0x4DAE1642 }},
{{ 0x01080101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x178C83CE, 0x2B399D94 }},
{{ 0x01040101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x50F63632, 0x4A9B7F80 }},
{{ 0x01020101, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA8468EE3, 0xBC18F06D }},
{{ 0x01018001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA2DC9E92, 0xFD3CDE92 }},
{{ 0x01014001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xCAC09F79, 0x7D031287 }},
{{ 0x01012001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x90BA680B, 0x22AEB525 }},
{{ 0x01011001, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xCE7A24F3, 0x50E280B6 }},
{{ 0x01010801, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x882BFF0A, 0xA01A0B87 }},
{{ 0x01010401, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x25610288, 0x924511C2 }},
{{ 0x01010201, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC71516C2, 0x9C75D170 }},
{{ 0x01010180, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x5199C29A, 0x52C9F059 }},
{{ 0x01010140, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xC22F0A29, 0x4A71F29F }},
{{ 0x01010120, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xEE371483, 0x714C02EA }},
{{ 0x01010110, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xA81FBD44, 0x8F9E522F }},
{{ 0x01010108, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x4F644C92, 0xE192DFED }},
{{ 0x01010104, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0x1AFA9A66, 0xA6DF92AE }},
{{ 0x01010102, 0x01010101 }, { 0x00000000, 0x00000000 }, { 0xB3C1CC71, 0x5CB879D8 }},
{{ 0x01010101, 0x80010101 }, { 0x00000000, 0x00000000 }, { 0x19D032E6, 0x4AB0BD8B }},
{{ 0x01010101, 0x40010101 }, { 0x00000000, 0x00000000 }, { 0x3CFAA7A7, 0xDC8720DC }},
{{ 0x01010101, 0x20010101 }, { 0x00000000, 0x00000000 }, { 0xB7265F7F, 0x447AC6F3 }},
{{ 0x01010101, 0x10010101 }, { 0x00000000, 0x00000000 }, { 0x9DB73B3C, 0x0D163F54 }},
{{ 0x01010101, 0x08010101 }, { 0x00000000, 0x00000000 }, { 0x8181B65B, 0xABF4A975 }},
{{ 0x01010101, 0x04010101 }, { 0x00000000, 0x00000000 }, { 0x93C9B640, 0x42EAA240 }},
{{ 0x01010101, 0x02010101 }, { 0x00000000, 0x00000000 }, { 0x55705308, 0x29705592 }},
{{ 0x01010101, 0x01800101 }, { 0x00000000, 0x00000000 }, { 0x8638809E, 0x878787A0 }},
{{ 0x01010101, 0x01400101 }, { 0x00000000, 0x00000000 }, { 0x41B9A79A, 0xF79AC208 }},
{{ 0x01010101, 0x01200101 }, { 0x00000000, 0x00000000 }, { 0x7A9BE42F, 0x2009A892 }},
{{ 0x01010101, 0x01100101 }, { 0x00000000, 0x00000000 }, { 0x29038D56, 0xBA6D2745 }},
{{ 0x01010101, 0x01080101 }, { 0x00000000, 0x00000000 }, { 0x5495C6AB, 0xF1E5DF51 }},
{{ 0x01010101, 0x01040101 }, { 0x00000000, 0x00000000 }, { 0xAE13DBD5, 0x61488933 }},
{{ 0x01010101, 0x01020101 }, { 0x00000000, 0x00000000 }, { 0x024D1FFA, 0x8904E389 }},
{{ 0x01010101, 0x01018001 }, { 0x00000000, 0x00000000 }, { 0xD1399712, 0xF99BF02E }},
{{ 0x01010101, 0x01014001 }, { 0x00000000, 0x00000000 }, { 0x14C1D7C1, 0xCFFEC79E }},
{{ 0x01010101, 0x01012001 }, { 0x00000000, 0x00000000 }, { 0x1DE5279D, 0xAE3BED6F }},
{{ 0x01010101, 0x01011001 }, { 0x00000000, 0x00000000 }, { 0xE941A33F, 0x85501303 }},
{{ 0x01010101, 0x01010801 }, { 0x00000000, 0x00000000 }, { 0xDA99DBBC, 0x9A03F379 }},
{{ 0x01010101, 0x01010401 }, { 0x00000000, 0x00000000 }, { 0xB7FC92F9, 0x1D8E92E9 }},
{{ 0x01010101, 0x01010201 }, { 0x00000000, 0x00000000 }, { 0xAE8E5CAA, 0x3CA04E85 }},
{{ 0x01010101, 0x01010180 }, { 0x00000000, 0x00000000 }, { 0x9CC62DF4, 0x3B6EED74 }},
{{ 0x01010101, 0x01010140 }, { 0x00000000, 0x00000000 }, { 0xD863DBB5, 0xC59A91A0 }},
{{ 0x01010101, 0x01010120 }, { 0x00000000, 0x00000000 }, { 0xA1AB2190, 0x545B91D7 }},
{{ 0x01010101, 0x01010110 }, { 0x00000000, 0x00000000 }, { 0x0875041E, 0x64C570F7 }},
{{ 0x01010101, 0x01010108 }, { 0x00000000, 0x00000000 }, { 0x5A594528, 0xBEBEF1CC }},
{{ 0x01010101, 0x01010104 }, { 0x00000000, 0x00000000 }, { 0xFCDB3291, 0xDE21F0C0 }},
{{ 0x01010101, 0x01010102 }, { 0x00000000, 0x00000000 }, { 0x869EFD7F, 0x9F265A09 }},
{{ 0x10469134, 0x89980131 }, { 0x00000000, 0x00000000 }, { 0x88D55E54, 0xF54C97B4 }},
{{ 0x10071034, 0x89988020 }, { 0x00000000, 0x00000000 }, { 0x0C0CC00C, 0x83EA48FD }},
{{ 0x10071034, 0xC8980120 }, { 0x00000000, 0x00000000 }, { 0x83BC8EF3, 0xA6570183 }},
{{ 0x10461034, 0x89988020 }, { 0x00000000, 0x00000000 }, { 0xDF725DCA, 0xD94EA2E9 }},
{{ 0x10869115, 0x19190101 }, { 0x00000000, 0x00000000 }, { 0xE652B53B, 0x550BE8B0 }},
{{ 0x10869115, 0x19580101 }, { 0x00000000, 0x00000000 }, { 0xAF527120, 0xC485CBB0 }},
{{ 0x5107B015, 0x19580101 }, { 0x00000000, 0x00000000 }, { 0x0F04CE39, 0x3DB926D5 }},
{{ 0x1007B015, 0x19190101 }, { 0x00000000, 0x00000000 }, { 0xC9F00FFC, 0x74079067 }},
{{ 0x31079154, 0x98080101 }, { 0x00000000, 0x00000000 }, { 0x7CFD82A5, 0x93252B4E }},
{{ 0x31079194, 0x98080101 }, { 0x00000000, 0x00000000 }, { 0xCB49A2F9, 0xE91363E3 }},
{{ 0x10079115, 0xB9080140 }, { 0x00000000, 0x00000000 }, { 0x00B588BE, 0x70D23F56 }},
{{ 0x31079115, 0x98080140 }, { 0x00000000, 0x00000000 }, { 0x406A9A6A, 0xB43399AE }},
{{ 0x1007D015, 0x89980101 }, { 0x00000000, 0x00000000 }, { 0x6CB77361, 0x1DCA9ADA }},
{{ 0x91079115, 0x89980101 }, { 0x00000000, 0x00000000 }, { 0x67FD21C1, 0x7DBB5D70 }},
{{ 0x9107D015, 0x89190101 }, { 0x00000000, 0x00000000 }, { 0x9592CB41, 0x10430787 }},
{{ 0x1007D015, 0x98980120 }, { 0x00000000, 0x00000000 }, { 0xA6B7FF68, 0xA318DDD3 }},
{{ 0x10079404, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0x4D102196, 0xC914CA16 }},
{{ 0x01079104, 0x91190401 }, { 0x00000000, 0x00000000 }, { 0x2DFA9F45, 0x73594965 }},
{{ 0x01079104, 0x91190101 }, { 0x00000000, 0x00000000 }, { 0xB4660481, 0x6C0E0774 }},
{{ 0x01079404, 0x91190401 }, { 0x00000000, 0x00000000 }, { 0x6E7E6221, 0xA4F34E87 }},
{{ 0x19079210, 0x981A0101 }, { 0x00000000, 0x00000000 }, { 0xAA85E746, 0x43233199 }},
{{ 0x10079119, 0x98190801 }, { 0x00000000, 0x00000000 }, { 0x2E5A19DB, 0x4D1962D6 }},
{{ 0x10079119, 0x981A0801 }, { 0x00000000, 0x00000000 }, { 0x23A866A8, 0x09D30894 }},
{{ 0x10079210, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0xD812D961, 0xF017D320 }},
{{ 0x10079115, 0x9819010B }, { 0x00000000, 0x00000000 }, { 0x05560581, 0x6E58608F }},
{{ 0x10048015, 0x98190101 }, { 0x00000000, 0x00000000 }, { 0xABD88E8B, 0x1B7716F1 }},
{{ 0x10048015, 0x98190102 }, { 0x00000000, 0x00000000 }, { 0x537AC95B, 0xE69DA1E1 }},
{{ 0x10048015, 0x98190108 }, { 0x00000000, 0x00000000 }, { 0xAED0F6AE, 0x3C25CDD8 }},
{{ 0x10029114, 0x98100104 }, { 0x00000000, 0x00000000 }, { 0xB3E35A5E, 0xE53E7B8D }},
{{ 0x10029115, 0x98190104 }, { 0x00000000, 0x00000000 }, { 0x61C79C71, 0x921A2EF8 }},
{{ 0x10029115, 0x98100201 }, { 0x00000000, 0x00000000 }, { 0xE2F5728F, 0x0995013C }},
{{ 0x10029116, 0x98100101 }, { 0x00000000, 0x00000000 }, { 0x1AEAC39A, 0x61F0A464 }},
{{ 0x7CA11045, 0x4A1A6E57 }, { 0x01A1D6D0, 0x39776742 }, { 0x690F5B0D, 0x9A26939B }},
{{ 0x0131D961, 0x9DC1376E }, { 0x5CD54CA8, 0x3DEF57DA }, { 0x7A389D10, 0x354BD271 }},
{{ 0x07A1133E, 0x4A0B2686 }, { 0x0248D438, 0x06F67172 }, { 0x868EBB51, 0xCAB4599A }},
{{ 0x3849674C, 0x2602319E }, { 0x51454B58, 0x2DDF440A }, { 0x7178876E, 0x01F19B2A }},
{{ 0x04B915BA, 0x43FEB5B6 }, { 0x42FD4430, 0x59577FA2 }, { 0xAF37FB42, 0x1F8C4095 }},
{{ 0x0113B970, 0xFD34F2CE }, { 0x059B5E08, 0x51CF143A }, { 0x86A560F1, 0x0EC6D85B }},
{{ 0x0170F175, 0x468FB5E6 }, { 0x0756D8E0, 0x774761D2 }, { 0x0CD3DA02, 0x0021DC09 }},
{{ 0x43297FAD, 0x38E373FE }, { 0x762514B8, 0x29BF486A }, { 0xEA676B2C, 0xB7DB2B7A }},
{{ 0x07A71370, 0x45DA2A16 }, { 0x3BDD1190, 0x49372802 }, { 0xDFD64A81, 0x5CAF1A0F }},
{{ 0x04689104, 0xC2FD3B2F }, { 0x26955F68, 0x35AF609A }, { 0x5C513C9C, 0x4886C088 }},
{{ 0x37D06BB5, 0x16CB7546 }, { 0x164D5E40, 0x4F275232 }, { 0x0A2AEEAE, 0x3FF4AB77 }},
{{ 0x1F08260D, 0x1AC2465E }, { 0x6B056E18, 0x759F5CCA }, { 0xEF1BF03E, 0x5DFA575A }},
{{ 0x58402364, 0x1ABA6176 }, { 0x004BD6EF, 0x09176062 }, { 0x88BF0DB6, 0xD70DEE56 }},
{{ 0x02581616, 0x4629B007 }, { 0x480D3900, 0x6EE762F2 }, { 0xA1F99155, 0x41020B56 }},
{{ 0x49793EBC, 0x79B3258F }, { 0x437540C8, 0x698F3CFA }, { 0x6FBF1CAF, 0xCFFD0556 }},
{{ 0x4FB05E15, 0x15AB73A7 }, { 0x072D43A0, 0x77075292 }, { 0x2F22E49B, 0xAB7CA1AC }},
{{ 0x49E95D6D, 0x4CA229BF }, { 0x02FE5577, 0x8117F12A }, { 0x5A6B612C, 0xC26CCE4A }},
{{ 0x018310DC, 0x409B26D6 }, { 0x1D9D5C50, 0x18F728C2 }, { 0x5F4C038E, 0xD12B2E41 }},
{{ 0x1C587F1C, 0x13924FEF }, { 0x30553228, 0x6D6F295A }, { 0x63FAC0D0, 0x34D9F793 }},
{{ 0x7CA11045, 0x4A1A6E57 }, { 0x01A1D6D0, 0x39776742 }, { 0x690F5B0D, 0x9A26939B }},
{{ 0x0131D961, 0x9DC1376E }, { 0x5CD54CA8, 0x3DEF57DA }, { 0x7A389D10, 0x354BD271 }},
{{ 0x07A1133E, 0x4A0B2686 }, { 0x0248D438, 0x06F67172 }, { 0x868EBB51, 0xCAB4599A }},
{{ 0x3849674C, 0x2602319E }, { 0x51454B58, 0x2DDF440A }, { 0x7178876E, 0x01F19B2A }},
{{ 0x04B915BA, 0x43FEB5B6 }, { 0x42FD4430, 0x59577FA2 }, { 0xAF37FB42, 0x1F8C4095 }},
{{ 0x0113B970, 0xFD34F2CE }, { 0x059B5E08, 0x51CF143A }, { 0x86A560F1, 0x0EC6D85B }},
{{ 0x0170F175, 0x468FB5E6 }, { 0x0756D8E0, 0x774761D2 }, { 0x0CD3DA02, 0x0021DC09 }},
{{ 0x43297FAD, 0x38E373FE }, { 0x762514B8, 0x29BF486A }, { 0xEA676B2C, 0xB7DB2B7A }},
{{ 0x07A71370, 0x45DA2A16 }, { 0x3BDD1190, 0x49372802 }, { 0xDFD64A81, 0x5CAF1A0F }},
{{ 0x04689104, 0xC2FD3B2F }, { 0x26955F68, 0x35AF609A }, { 0x5C513C9C, 0x4886C088 }},
{{ 0x37D06BB5, 0x16CB7546 }, { 0x164D5E40, 0x4F275232 }, { 0x0A2AEEAE, 0x3FF4AB77 }},
{{ 0x1F08260D, 0x1AC2465E }, { 0x6B056E18, 0x759F5CCA }, { 0xEF1BF03E, 0x5DFA575A }},
{{ 0x58402364, 0x1ABA6176 }, { 0x004BD6EF, 0x09176062 }, { 0x88BF0DB6, 0xD70DEE56 }},
{{ 0x02581616, 0x4629B007 }, { 0x480D3900, 0x6EE762F2 }, { 0xA1F99155, 0x41020B56 }},
{{ 0x49793EBC, 0x79B3258F }, { 0x437540C8, 0x698F3CFA }, { 0x6FBF1CAF, 0xCFFD0556 }},
{{ 0x4FB05E15, 0x15AB73A7 }, { 0x072D43A0, 0x77075292 }, { 0x2F22E49B, 0xAB7CA1AC }},
{{ 0x49E95D6D, 0x4CA229BF }, { 0x02FE5577, 0x8117F12A }, { 0x5A6B612C, 0xC26CCE4A }},
{{ 0x018310DC, 0x409B26D6 }, { 0x1D9D5C50, 0x18F728C2 }, { 0x5F4C038E, 0xD12B2E41 }},
{{ 0x1C587F1C, 0x13924FEF }, { 0x30553228, 0x6D6F295A }, { 0x63FAC0D0, 0x34D9F793 }},
};

static	deablk	decrypt[][3] = {
{{ 0x80010101, 0x01010101 }, { 0x95A8D728, 0x13DAA94D }, { 0x00000000, 0x00000000 }},
{{ 0x40010101, 0x01010101 }, { 0x0EEC1487, 0xDD8C26D5 }, { 0x00000000, 0x00000000 }},
{{ 0x20010101, 0x01010101 }, { 0x7AD16FFB, 0x79C45926 }, { 0x00000000, 0x00000000 }},
{{ 0x10010101, 0x01010101 }, { 0xD3746294, 0xCA6A6CF3 }, { 0x00000000, 0x00000000 }},
{{ 0x08010101, 0x01010101 }, { 0x809F5F87, 0x3C1FD761 }, { 0x00000000, 0x00000000 }},
{{ 0x04010101, 0x01010101 }, { 0xC02FAFFE, 0xC989D1FC }, { 0x00000000, 0x00000000 }},
{{ 0x02010101, 0x01010101 }, { 0x4615AA1D, 0x33E72F10 }, { 0x00000000, 0x00000000 }},
{{ 0x01800101, 0x01010101 }, { 0x20551233, 0x50C00858 }, { 0x00000000, 0x00000000 }},
{{ 0x01400101, 0x01010101 }, { 0xDF3B99D6, 0x577397C8 }, { 0x00000000, 0x00000000 }},
{{ 0x01200101, 0x01010101 }, { 0x31FE1736, 0x9B5288C9 }, { 0x00000000, 0x00000000 }},
{{ 0x01100101, 0x01010101 }, { 0xDFDD3CC6, 0x4DAE1642 }, { 0x00000000, 0x00000000 }},
{{ 0x01080101, 0x01010101 }, { 0x178C83CE, 0x2B399D94 }, { 0x00000000, 0x00000000 }},
{{ 0x01040101, 0x01010101 }, { 0x50F63632, 0x4A9B7F80 }, { 0x00000000, 0x00000000 }},
{{ 0x01020101, 0x01010101 }, { 0xA8468EE3, 0xBC18F06D }, { 0x00000000, 0x00000000 }},
{{ 0x01018001, 0x01010101 }, { 0xA2DC9E92, 0xFD3CDE92 }, { 0x00000000, 0x00000000 }},
{{ 0x01014001, 0x01010101 }, { 0xCAC09F79, 0x7D031287 }, { 0x00000000, 0x00000000 }},
{{ 0x01012001, 0x01010101 }, { 0x90BA680B, 0x22AEB525 }, { 0x00000000, 0x00000000 }},
{{ 0x01011001, 0x01010101 }, { 0xCE7A24F3, 0x50E280B6 }, { 0x00000000, 0x00000000 }},
{{ 0x01010801, 0x01010101 }, { 0x882BFF0A, 0xA01A0B87 }, { 0x00000000, 0x00000000 }},
{{ 0x01010401, 0x01010101 }, { 0x25610288, 0x924511C2 }, { 0x00000000, 0x00000000 }},
{{ 0x01010201, 0x01010101 }, { 0xC71516C2, 0x9C75D170 }, { 0x00000000, 0x00000000 }},
{{ 0x01010180, 0x01010101 }, { 0x5199C29A, 0x52C9F059 }, { 0x00000000, 0x00000000 }},
{{ 0x01010140, 0x01010101 }, { 0xC22F0A29, 0x4A71F29F }, { 0x00000000, 0x00000000 }},
{{ 0x01010120, 0x01010101 }, { 0xEE371483, 0x714C02EA }, { 0x00000000, 0x00000000 }},
{{ 0x01010110, 0x01010101 }, { 0xA81FBD44, 0x8F9E522F }, { 0x00000000, 0x00000000 }},
{{ 0x01010108, 0x01010101 }, { 0x4F644C92, 0xE192DFED }, { 0x00000000, 0x00000000 }},
{{ 0x01010104, 0x01010101 }, { 0x1AFA9A66, 0xA6DF92AE }, { 0x00000000, 0x00000000 }},
{{ 0x01010102, 0x01010101 }, { 0xB3C1CC71, 0x5CB879D8 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x80010101 }, { 0x19D032E6, 0x4AB0BD8B }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x40010101 }, { 0x3CFAA7A7, 0xDC8720DC }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x20010101 }, { 0xB7265F7F, 0x447AC6F3 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x10010101 }, { 0x9DB73B3C, 0x0D163F54 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x08010101 }, { 0x8181B65B, 0xABF4A975 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x04010101 }, { 0x93C9B640, 0x42EAA240 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x02010101 }, { 0x55705308, 0x29705592 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01800101 }, { 0x8638809E, 0x878787A0 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01400101 }, { 0x41B9A79A, 0xF79AC208 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01200101 }, { 0x7A9BE42F, 0x2009A892 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01100101 }, { 0x29038D56, 0xBA6D2745 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01080101 }, { 0x5495C6AB, 0xF1E5DF51 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01040101 }, { 0xAE13DBD5, 0x61488933 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01020101 }, { 0x024D1FFA, 0x8904E389 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01018001 }, { 0xD1399712, 0xF99BF02E }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01014001 }, { 0x14C1D7C1, 0xCFFEC79E }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01012001 }, { 0x1DE5279D, 0xAE3BED6F }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01011001 }, { 0xE941A33F, 0x85501303 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010801 }, { 0xDA99DBBC, 0x9A03F379 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010401 }, { 0xB7FC92F9, 0x1D8E92E9 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010201 }, { 0xAE8E5CAA, 0x3CA04E85 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010180 }, { 0x9CC62DF4, 0x3B6EED74 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010140 }, { 0xD863DBB5, 0xC59A91A0 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010120 }, { 0xA1AB2190, 0x545B91D7 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010110 }, { 0x0875041E, 0x64C570F7 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010108 }, { 0x5A594528, 0xBEBEF1CC }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010104 }, { 0xFCDB3291, 0xDE21F0C0 }, { 0x00000000, 0x00000000 }},
{{ 0x01010101, 0x01010102 }, { 0x869EFD7F, 0x9F265A09 }, { 0x00000000, 0x00000000 }},
};

static
int		blkcmp( const deablk a, const deablk b )
{
	return ( a[ 0 ] == b[ 0 ] && a[ 1 ] == b[ 1 ] );
}

#undef	normal
#if	LITTLEENDIAN
static
void	normal( deablk b )
{
	union	{
		unsigned int	card;
		unsigned char	byte[ 4 ];
	} x, y;

	x.card = b[ 0 ];
	y.byte[ 0 ] = x.byte[ 3 ],
	y.byte[ 1 ] = x.byte[ 2 ],
	y.byte[ 2 ] = x.byte[ 1 ],
	y.byte[ 3 ] = x.byte[ 0 ];
	b[ 0 ] = y.card;

	x.card = b[ 1 ];
	y.byte[ 0 ] = x.byte[ 3 ],
	y.byte[ 1 ] = x.byte[ 2 ],
	y.byte[ 2 ] = x.byte[ 1 ],
	y.byte[ 3 ] = x.byte[ 0 ];
	b[ 1 ] = y.card;
}
#endif

#if	BIGENDIAN
#define	normal( x )	(void)0
#endif


#define	TBLSIZE(a)		(sizeof(a)/sizeof((a)[0]))

int		main( void )
{
	static	deablk	data, key, ciph;
			unsigned i;
			int		error = 0;
			void	*keytab;

	keytab = dea_keytab();

	(void)memcpy( data, "computer", 8 );
	(void)memcpy( key,  "program", 7 );
	dea_keyconv( (unsigned char *)key );

	ciph[ 0 ] = patterson[ CIPHCOL ][ 0 ], ciph[ 1 ] = patterson[ CIPHCOL ][ 1 ];

	normal( ciph );

	dea_schedule( (unsigned char *)key, DEAENCRYPT, keytab );
	dea( data, keytab );

	if( ! blkcmp( data, ciph ))
	{
		(void)printf( "0) %3d: %08X-%08X != %08X-%08X\n", 0,
			patterson[ CIPHCOL ][ 0 ], patterson[ CIPHCOL ][ 1 ],
			data[ 0 ], data[ 1 ] );
		error = 1;
	}

	for( i = 0; i < TBLSIZE( willis ); i++ )
	{
		data[ 0 ]  = willis[ i ][ TEXTCOL ][ 0 ] ;
		data[ 1 ]  = willis[ i ][ TEXTCOL ][ 1 ] ;
		key [ 0 ]  = willis[ i ][ KEYCOL ][ 0 ] ;
		key [ 1 ]  = willis[ i ][ KEYCOL ][ 1 ] ;
		ciph[ 0 ]  = willis[ i ][ CIPHCOL ][ 0 ] ;
		ciph[ 1 ]  = willis[ i ][ CIPHCOL ][ 1 ] ;
		normal( data ); normal( key ); normal( ciph );

		dea_schedule( (unsigned char *)key, DEAENCRYPT, keytab );
		dea( data, keytab );

		if( ! blkcmp( data, ciph ))
		{
			(void)printf( "1) %3d: %08X-%08X != %08X-%08X\n", i,
				willis[ i ][ CIPHCOL ][ 0 ], willis[ i ][ CIPHCOL ][ 1 ],
				data[ 0 ], data[ 1 ] );
			error = 1;
		}
	}

	for( i = 0; i < TBLSIZE( encrypt ); i++ )
	{
		data[ 0 ] = encrypt[ i ][ TEXTCOL ][ 0 ];
		data[ 1 ] = encrypt[ i ][ TEXTCOL ][ 1 ];
		key [ 0 ] = encrypt[ i ][ KEYCOL ][ 0 ];
		key [ 1 ] = encrypt[ i ][ KEYCOL ][ 1 ];
		ciph[ 0 ] = encrypt[ i ][ CIPHCOL ][ 0 ];
		ciph[ 1 ] = encrypt[ i ][ CIPHCOL ][ 1 ];
		normal( data ); normal( key ); normal( ciph );

		dea_schedule( (unsigned char *)key, DEAENCRYPT, keytab );
		dea( data, keytab );

		if( ! blkcmp( data, ciph ))
		{
			(void)printf( "2) %3d: %08X-%08X != %08X-%08X\n", i,
				encrypt[ i ][ CIPHCOL ][ 0 ], encrypt[ i ][ CIPHCOL ][ 1 ],
				data[ 0 ], data[ 1 ] );
			error = 1;
		}
	}

	for( i = 0; i < TBLSIZE( decrypt ); i++ )
	{
		data[ 0 ] = decrypt[ i ][ TEXTCOL ][ 0 ];
		data[ 1 ] = decrypt[ i ][ TEXTCOL ][ 1 ];
		key [ 0 ] = decrypt[ i ][ KEYCOL ][ 0 ];
		key [ 1 ] = decrypt[ i ][ KEYCOL ][ 1 ];
		ciph[ 0 ] = decrypt[ i ][ CIPHCOL ][ 0 ];
		ciph[ 1 ] = decrypt[ i ][ CIPHCOL ][ 1 ];
		normal( data ); normal( key ); normal( ciph );

		dea_schedule( (unsigned char *)key, DEADECRYPT, keytab );
		dea( data, keytab );

		if( ! blkcmp( data, ciph ))
		{
			(void)printf( "3) %3d: %08X-%08X != %08X-%08X\n", i,
				decrypt[ i ][ CIPHCOL ][ 0 ], decrypt[ i ][ CIPHCOL ][ 1 ],
				data[ 0 ], data[ 1 ] );
			error = 1;
		}
	}

	return error;
}
