/*
 * $Id: util.c,v 1.4 1999/07/29 20:27:07 malte Exp $
 *
 * $Log: util.c,v $
 * Revision 1.4  1999/07/29 20:27:07  malte
 * added GPL notice comment
 *
 * Revision 1.3  1994/02/19 11:55:22  malte
 * *** empty log message ***
 *
 * Revision 1.1  1994/02/18  17:09:16  malte
 * Initial revision
 *
 *
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "intern.h"

void	dea_keyconv( byte *str )
{
	str[ 7 ] = (byte)((card) str[ 6 ] << 1 );
	str[ 6 ] = (byte)((card) str[ 5 ] << 2
			 | ((card) str[ 6 ] & 0x00000080 ) >> 6 );
	str[ 5 ] = (byte)((card) str[ 4 ] << 3
			 | ((card) str[ 5 ] & 0x000000C0 ) >> 5 );
	str[ 4 ] = (byte)((card) str[ 3 ] << 4
			 | ((card) str[ 4 ] & 0x000000E0 ) >> 4 );
	str[ 3 ] = (byte)((card) str[ 2 ] << 5
			 | ((card) str[ 3 ] & 0x000000F0 ) >> 3 );
	str[ 2 ] = (byte)((card) str[ 1 ] << 6
			 | ((card) str[ 2 ] & 0x000000F8 ) >> 2 );
	str[ 1 ] = (byte)((card) str[ 0 ] << 7
			 | ((card) str[ 1 ] & 0x000000FC ) >> 1 );
}

#ifdef	DEBUG
#include <stdio.h>

void	printch( card x )
{
	printf( "%02X %02X %02X %02X",
		( x >> 24 ) & 0xFF,
		( x >> 16 ) & 0xFF,
		( x >>  8 ) & 0xFF,
		( x >>  0 ) & 0xFF );
}

void	printcb( card x )
{
	printf( "%u%u%u%u%u%u%u%u %u%u%u%u%u%u%u%u %u%u%u%u%u%u%u%u %u%u%u%u%u%u%u%u",
		bitc(  1, x ), bitc(  2, x ), bitc(  3, x ), bitc(  4, x ),
		bitc(  5, x ), bitc(  6, x ), bitc(  7, x ), bitc(  8, x ),
		bitc(  9, x ), bitc( 10, x ), bitc( 11, x ), bitc( 12, x ),
		bitc( 13, x ), bitc( 14, x ), bitc( 15, x ), bitc( 16, x ),
		bitc( 17, x ), bitc( 18, x ), bitc( 19, x ), bitc( 20, x ),
		bitc( 21, x ), bitc( 22, x ), bitc( 23, x ), bitc( 24, x ),
		bitc( 25, x ), bitc( 26, x ), bitc( 27, x ), bitc( 28, x ),
		bitc( 29, x ), bitc( 30, x ), bitc( 31, x ), bitc( 32, x ));
}

void	showb( const char *msg, const card *blk, int wait )
{
	char	c;

	if( msg != NULL )
		fputs( msg, stdout );

	printcb( blk[ 0 ] );
	printf( " " );
	printcb( blk[ 1 ] );

	switch( wait )
	{
		case 0:
			printf( "\n" );
			return;
		default:
			while(( c = fgetc( stdin )) != '\n' )
				;
	}
}

void	showr( const char *msg, card z, card y, int wait )
{
	card	x[2];

	x[ 0 ] = ror1( z ); x[ 1 ] = ror1( y );
	showb( msg, x, wait );
}
#endif
