/*
 * $Id: key.c,v 1.4 1999/07/29 20:27:33 malte Exp $
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/*
 * key management functions to assure a key is reasonably save, that is
 * contains at least 49 bits ( 7 bytes x 7 bits ) of data such as ASCII
 * characters do.
 *
 * getpass is a function reading a password from /dev/tty without echoing
 * the characters on the screen. The result is a pointer to a '\0' terminated
 * string, at most 8 characters long.
 */

#include <stdio.h>
#include <string.h>

#include "dea.h"
#include "comm.h"

extern	char	*getpass( const char * );

int		keycheck( char *keystr )
{
	switch( (unsigned)strlen( keystr ))
	{
		case 0:
		case 1:
		case 2:
		case 3:
		case 4:
		case 5:
		case 6:
			(void)fprintf( stderr, "%s: please use a longer key\n", prgname );
			return 1;
		case 7:
			dea_keyconv( (unsigned char *)keystr );
		default:
			return 0;
	}
}

int		readkey( char *res, int reread )
{
	char	*pw, buff[ 100 ];

	if(( pw = getpass( "key  : " )) == NULL )
	{
		(void)fputs( "readkey: bad input\n", stderr );
		return 0;
	}

	if( reread )
	{
		strcpy( buff, pw );

		if(( pw = getpass( "again: " )) == NULL )
		{
			(void)fputs( "readkey: bad input\n", stderr );
			return 0;
		}
		if( strcmp( pw, buff ) != 0 )
		{
			(void)fputs( "readkey: keys don't match\n", stderr );
			return 0;
		}
	}

	(void)strcpy( res, pw );

	return keycheck( res );
}
