/*
 * $Id: pipe.c,v 1.3 1999/07/29 20:27:33 malte Exp $
 */
/*
 * Copyright (C) 1994-1999  Malte Uhl
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include <stdio.h>
#include "dea.h"
#include "comm.h"

static
int		execute( const char *prog )
{
	(void)execl( prog, prog, verbose ? "-v" : NULL, NULL );
	return -2;
}

static	pid_t	child = -1;
static	int		fds[ 2 ];

#define	READEND		fds[ 0 ]
#define	WRITEEND	fds[ 1 ]

int		filtwait( void )
{
	int		stat;

	if( child == -1 )
		return 0;

	if( waitpid( child, &stat, 0 ) == child )
	{
		child = -1;
		if( WIFEXITED( stat ))
		{
			if( WEXITSTATUS( stat ))
			{
				(void)fputs( "filter exit code != 0\n", stderr );
				return 1;
			}
			else
				return 0;
		}
		else
		{
			(void)fputs( "filter killed by signal\n", stderr );
			return 1;
		}
	}
	else
		return -1;
}

static
int		fin( const char *filter, int fd )
{
	if( pipe( fds ) != 0 )
		return -1;

	switch( child = fork())
	{
		case -1:

			(void)close( READEND );
			(void)close( WRITEEND );
			return -1;

		case  0:			/* child */

			(void)close( READEND );

			if( fd != STDIN_FILENO )
			{
				if( dup2( fd, STDIN_FILENO ) == -1 )
					exit( -1 );

				(void)close( fd );
			}

			if( dup2( WRITEEND, STDOUT_FILENO ) == -1 )
				exit( -1 );

			(void)close( WRITEEND );
			exit( execute( filter ));

		default:			/* parent */

			(void)close( WRITEEND );

			if( dup2( READEND, fd ) == -1 )
				return -1;

			(void)close( READEND );
			return 0;
	}
}

static
int		fout( const char *filter, int fd )
{
	if( pipe( fds ) != 0 )
		return -1;

	switch( child = fork())
	{
		case -1:

			(void)close( READEND );
			(void)close( WRITEEND );
			return -1;

		case  0:			/* child */

			(void)close( WRITEEND );

			if( dup2( READEND, STDIN_FILENO ) == -1 )
				exit( -2 );

			(void)close( READEND );

			if( fd != STDOUT_FILENO )
			{
				if( dup2( fd, STDOUT_FILENO ) == -1 )
					exit( -2 );

				(void)close( fd );
			}
			exit( execute( filter ));

		default:			/* parent */

			(void)close( READEND );

			if( dup2( WRITEEND, fd ) == -1 )
				return -1;

			(void)close( WRITEEND );
			return 0;
	}
}

int		filter( int direction, const char *filt, int fd )
{
	return direction ? fout( filt, fd ) : fin( filt, fd );
}
