#define MAX_PACK_SIZE 2048

#define LOG_MAC_ADDRESSES 1

#define LOG_IP_ADDRESSES 1

#define LOG_TO_FILE 1

#define CRYPT_LOG 0

#define TCP 1
#define UDP 0
#define ICMP 0

#define LOG_SRC_PORT 1
#define LOG_DST_PORT 1

#if LOG_MAC_ADDRESSES
	#define LOG_SRC_ADDRESS 1
	#define LOG_DST_ADDRESS 1
#endif

#if LOG_IP_ADDRESSES
	#define LOG_SRC_IP 1
	#define LOG_DST_IP 1
#endif

#if LOG_TO_FILE
	#define LOG_FILE "/tmp/sniffer.log"
	#define FILE_PERM 0600
	#define OWNER "root"
	#define GROUP "root"
	#if CRYPT_LOG
		#define CRYPT_KEY "fruta"
		#define XOR 0
		#define DES 0
		#define TRIPLEDES 0
		#define BLOWFISH 0
		#define CHECK XOR + DES + TRIPLEDES + BLOWFISH
		#if CHECK > 1
		    #error Please choose just ONE criptographic algoritm.
		#endif
		#if XOR < 1
		    #if DES < 1
		    	#if TRIPLEDES < 1
			    #if BLOWFISH < 1
				#error Please choose a criptographic algorithm first.
			    #endif
			#endif
		    #endif
		#endif
	#endif
#endif

#if TCP
	#define PROTOCOL "tcp"
	int PORTS [] = {23, 
			21};
#elif UDP
	#define PROTOCOL "udp"
	int PORTS [] = {23, 
			21};
#elif ICMP
	#define PROTOCOL "icmp"
#else 
#ifndef PROTOCOL
    #error You must define a protocol to listen to !. Please modify config.h.
#endif
#endif
