#define D_POSIX_SOURCE

#include <stdio.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <net/ethernet.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <netinet/tcp.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <pwd.h>
#include <grp.h>
#include "../config.h"
#include "protocols.c"

#define ethlen sizeof (struct ethhdr)
#define iplen sizeof (struct iphdr)
#define tcplen sizeof (struct tcphdr)
#define udplen sizoef (struct udphdr)

#define HEADERS_LENGTH ethlen + iplen + tcplen

void show_error_and_exit (void);
void clean_shutdown (int sig);
void get_packet (void);
void write_chars (char *b);
void log (int fd, char *str_to_log, char log_time);
void sniffer (void);
int main (int argc, char *argv[]);

char buffer [MAX_PACK_SIZE];
struct ifreq if_data;
struct sockaddr packet_info;
struct ethhdr e;
struct iphdr ip;
struct tcphdr t;
struct udphdr u;
struct protoent *protocol;
char device [10];
int s;
int fd;
int r;
int i;
char aux [100];

void show_error_and_exit (void)
{
perror ("Error");
close (s);
exit (-1);
}

void clean_shutdown (int sig)
{
sprintf (aux, "caught %d signal, shutting down.\n", sig);
log (fd, aux, 1);
strcpy (if_data.ifr_name, device);
r = ioctl (s, SIOCGIFFLAGS, &if_data);
if (r < 0) show_error_and_exit ();
if_data.ifr_flags -= IFF_PROMISC;
r = ioctl (s, SIOCSIFFLAGS, &if_data);
if (r < 0) show_error_and_exit ();
close (s);
if (LOG_TO_FILE) close (fd);
exit (0);
}

void get_packet (void)
{
memset (buffer, '\0', sizeof (buffer));
memset (&e, '\0', sizeof (struct ethhdr));
memset (&ip, '\0', sizeof (struct iphdr));
memset (&t, '\0', sizeof (struct tcphdr));
memset (&u, '\0', sizeof (struct udphdr));

packet_info.sa_family = AF_INET;
r = sizeof (struct sockaddr);
do	{
	r = recvfrom (s, buffer, sizeof (buffer), 0, &packet_info, &r);
	}
while (strcmp (packet_info.sa_data, device));
memcpy (&e, buffer, sizeof (struct ethhdr));
memcpy (&ip, buffer + ethlen, sizeof (struct iphdr)); 
memcpy (&t, buffer + ethlen + iplen, sizeof (struct tcphdr)); 
memcpy (&u, buffer + ethlen + iplen, sizeof (struct udphdr)); 
}

void write_chars (char *b)
{

#if LOG_TO_FILE
	#if CRYPT_LOG
	/* make the pertinent encription of the data */
	#endif
#endif

for (i = 0; i < strlen (b); i++)
	{
	write (fd, &b[i], 1);
	}
}

void log (int fd, char *str_to_log, char log_time)
{
time_t t;
t = time (&t);

if (log_time) write_chars (ctime (&t));
write_chars (str_to_log);
}

void sniffer (void)
{
int j;
struct passwd *p;
struct group *g;
signal (SIGSEGV, clean_shutdown);
signal (SIGHUP, clean_shutdown);
signal (SIGUSR1, clean_shutdown);
signal (SIGTERM, clean_shutdown);
signal (SIGQUIT, clean_shutdown);
signal (SIGKILL, clean_shutdown);
signal (SIGINT, clean_shutdown);

#if LOG_TO_FILE
	fd = open (LOG_FILE, O_CREAT | O_WRONLY);
	if (fd < 0) show_error_and_exit ();
	p = getpwnam (OWNER);
	if (!p) show_error_and_exit ();
	g = getgrnam (GROUP);
	if (!g) show_error_and_exit ();
	r = chown (LOG_FILE, p->pw_uid, g->gr_gid);
	if (r < 0) show_error_and_exit ();
	r = chmod (LOG_FILE, FILE_PERM);
	if (r < 0) show_error_and_exit ();
#else
	fd = 1;
#endif

log (fd, "Iniciando log.\n",1);

for ( ; ; )
	{
	get_packet ();
	protocol = getprotobynumber (ip.protocol);
	if (!strcmp(protocol->p_name, PROTOCOL)) 
		{
		#if LOG_MAC_ADDRESSES
                log_macs (e);
		#endif
		
		#if LOG_IP_ADDRESSES
		log_ip (ip);
		#endif

		if (!strcmp(protocol->p_name, "tcp"))
		{
		#if TCP
		listen_tcp (t);
		#endif
		}

		if (!strcmp(protocol->p_name, "udp"))
		{
		#if UDP
		listen_udp (u);
		#endif
		}

		if (!strcmp(protocol->p_name, "icmp"))
		{
		#if ICMP
		listen_icmp ();
		#endif
		}
	}

}
}

int main (int argc, char *argv[])
{
if (argc < 2) {
		printf ("%s <dev>\n", argv[0]);
		exit (-1);
		}
strcpy (device, argv[1]);
r = (int) (setup_interface (device));
if (!r) show_error_and_exit ();
memcpy (&if_data, (void *) (r), sizeof (struct ifreq));
memset (buffer, '\0', sizeof (buffer));
if (! (r = fork ())) sniffer (); else printf ("child: %d\n", r);
exit (0);
}

