#include <net/if.h>
#include <net/ethernet.h>

extern void log (int fd, char *str_to_log, char log_time);
extern int fd;

#if LOG_MAC_ADDRESSES
void log_macs (struct ethhdr e)
{
char aux [100];
memset (aux, '\0', sizeof (aux));
#if LOG_SRC_ADDRESS
sprintf (aux, "source MAC address: %x:%x:%x:%x:%x:%x\n", e.h_source[0],
                                                        e.h_source[1],
                                                        e.h_source[2],
                                                        e.h_source[3],
                                                        e.h_source[4],
                                                        e.h_source[5]);
log (fd, aux, 0);
#endif

#if LOG_DST_ADDRESS
memset (aux, '\0', sizeof (aux));
sprintf (aux, "target MAC address: %x:%x:%x:%x:%x:%x\n", e.h_dest[0],
                                                        e.h_dest[1],
                                                        e.h_dest[2],
                                                        e.h_dest[3],
                                                        e.h_dest[4],
                                                        e.h_dest[5]);
log (fd, aux, 0);
#endif
}

#endif

#if LOG_IP_ADDRESSES

void log_ip (struct iphdr i)
{
char aux [100];
memset (aux, '\0', sizeof (aux));

#if LOG_SRC_IP_ADDRESS
sprintf (aux, "source IP address: \n", inet_ntoa (i.saddr));
log (fd, aux, 0);
#endif

#if LOG_SRC_IP_ADDRESS
sprintf (aux, "source IP address: \n", inet_ntoa (i.saddr));
log (fd, aux, 0);
#endif
}
#endif

#if UDP
void listen_udp (struct udphdr u)
{
int j;
char aux [100];

for (j = 0; j < sizeof (PORTS)/4; j++)
{
if (ntohs(u.dest) == PORTS[j])
        {
        log (fd, "Packet!\n", 1);
        #if LOG_SRC_PORT
		memset (aux, '\0', sizeof (aux));
                sprintf (aux, "source udp port: %d\n",ntohs (u.source));
                log (fd, aux, 0);
        #endif
        #if LOG_DST_PORT
                memset (aux, '\0', sizeof (aux));
		sprintf (aux, "target udp port: %d\n",ntohs (u.dest));
                log (fd, aux, 0);
        #endif

        }
}
}
#endif

#if TCP
void listen_tcp (struct tcphdr t)
{
int j;
char aux [100];

for (j = 0; j < sizeof (PORTS)/4; j++)
{
if ((ntohs(t.dest) == PORTS[j]) && t.syn)
        {
        log (fd, "Packet!\n", 1);
        #if LOG_SRC_PORT
		memset (aux, '\0', sizeof (aux));
                sprintf (aux, "source tcp port: %d\n",ntohs (t.source));
                log (fd, aux, 0);
        #endif
        #if LOG_DST_PORT
                memset (aux, '\0', sizeof (aux));
		sprintf (aux, "target tcp port: %d\n",ntohs (t.dest));
                log (fd, aux, 0);
        #endif

        }
}
}
#endif


