/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/* (c) by G. Caronni in 1995                              18.11.95
 *
 * Contains certificate storage management, IO and calculation of 
 * shared secrets
 *
 */

#ifndef CERT_DB__H
#define CERT_DB_H

extern int db_init(void);
extern void db_exit(void);

extern dh_data *db_cert_init(void);
extern void db_cert_drop(dh_data *data);
extern dh_data *db_secret_read(char *fnam);
extern dh_data *db_public_read(char *fnam);
/* public/secret_write exported for cert_make/_gen */
extern int db_public_write(FILE *f, dh_data *data, char *name, char *from);
extern int db_secret_write(FILE *f, dh_data *data, char *name, char *from);
extern void db_unique_disk_save(dh_data **res, char *from, int flag);
extern void db_dump(FILE *f, dh_data *data);

/* if next==0 then start at beginning, if next==data then continue with next
 * returns -1 on last matching. if called with -1 only tries a load.
 * if secret flag is set, the secret value is searched and filled in.
 */
extern dh_data *db_public_find_load(dh_data *next, u_char nsid, u_char *mkid);

extern int db_secret_add(dh_data *public);

extern char *make_name(u_char, u_char *);
#endif
