/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/* (c) by G. Caronni in 1995				18.11.95
 *
 * Global declarations & structs for the certificate part of the skip daemon
 */

#ifndef CERT_DEFS__H
#define CERT_DEFS__H

#include "../include/skip_defs.h"

#define IN_CERT /* for cert_main.h */

#define SEND_PORT	SKIP_UDP_RECV_PORT
#define RECV_PORT	SKIP_UDP_SEND_PORT

#define CERT_RETRIES 3 /* for certificate queries */
#define RETRY_DELAY 500 /* in msec */
#define REMEMBER_FAILURE 180 /* seconds */
#define KEEP_ENTRY 1800 /* how long to keep an unexported dh_data entry */

/*#define MAX_ENTRY 10000 * when shall we begin to purge by LRU */
/*#define MSEC_PER_DH 100 * how large is the minimal interval between DH ops*/

#define DEFAULT_NSID    SKIP_NSID_IPV4 	/* if no NSID given, this type will be used */
#define MAX_NSID	SKIP_NUM_NSID-1 /* last valid NSID, see cert_db.c */

typedef struct ip_addr {
    u_long a[4]; /* size already v6, for compatibility with skipd */
} ip_addr;

/* Main data structure for storage of received and active certificates
 * this is closely linked to dh_secret in cert_main.h take care to update
 * both if one of the public fields changes! */

typedef struct dh_data {
    int secret_len;             /* number of valid bytes in shared secret */
    u_char *secret;             /* shared secret, MSB first, without n */
    ip_addr oip;                /* own and remote IPv6 addresses, v4 addr */
    ip_addr rip;                /* is in the first 4 bytes. add ports later */
    u_char ons;                 /* own and remote NSID */
    u_char rns;
    u_char *omk;                /* own and remote master key ID */
    u_char *rmk;
    u_char old_ons;             /* own and remote NSID -- currently the same */
    u_char old_rns;             /* as above. This might change in the future */
    u_char *old_omk;            /* if and when lookup gets smart enough to */
    u_char *old_rmk;            /* find 'related' keys */
    int ireq;                   /* for the SKIP cache - as in cert_discover */

                                /* PRIVATE PART */
    struct dh_data *prev;
    struct dh_data *next;
    char *public;               /* where the public certificate is stored */
    char *private;              /* where our own secret value is stored */
    u_long begins;
    u_long expires;
    void *p;            /* prime for modulo          MPI internal format */
    void *g;            /* generator for exp         MPI internal format */
    void *j;            /* own private value         MPI internal format */
    void *ki;           /* remote public value       MPI internal format */
    void *kij;          /* combined shared secret    MPI internal format */

    void *cert_data;    /* unspec. struct of certificate data -- mapped to 
			 * a SkipCert object if suncerts are used.
			 */
} dh_data;


extern dh_data *cert_first;

extern void (*receiver)(dh_data *reply);

extern char *data_path; /* XXX check trailing slash */
#endif
