/****************************************************************************
 *  $Id: cert_event.c,v 1.5 1996/02/19 20:58:48 caronni Exp $
 * description: Event-handling routines for the genio-lib
 * Revision 1.1  1993/12/23  11:05:39  caronni
 ****************************************************************************/

#include <assert.h>
#include <sys/types.h>
#include <sys/time.h>
#include <malloc.h>
#include <stdio.h>

#include "cert_defs.h"
#include "cert_event.h"

#ifdef SOLARIS
/*Missing in Solaris 2.3*/
extern int gettimeofday(struct timeval *tp, struct timezone *tzp);
#endif 


typedef struct eventS {
    struct timeval when;
    void (*proc)(void *, struct timeval *);
    void *param;
    struct eventS *next;
    int new:1;
/*    struct eventS *prev;*/
} event;


static event *event_anchor=NULL;

#define TIMCOMP(a,b) ((a).tv_sec>(b).tv_sec||((a).tv_sec==(b).tv_sec&&(a).tv_usec>(b).tv_usec)) /* return 1 if a>b */

int event_init(void){return 0;}
void event_exit(void){event_remove(NULL,NULL,NULL);}


/* Be sure not to remove the event to which next points! */

void *event_find(void *next, struct timeval **when, 
		    void (**proc)(void *,struct timeval *), void **param)
{
    event *e=next;

    if (e) e=e->next;
    else e=event_anchor;
    while(e) {
	if ((when==NULL  || *when==NULL  || ((*when)->tv_sec==e->when.tv_sec &&
			                (*when)->tv_usec==e->when.tv_usec))  &&
            (proc==NULL  || *proc==NULL  ||  (*proc)==e->proc)               &&
	    (param==NULL || *param==NULL ||  (*param)==e->param)) {

	    if (when) *when=&(e->when);
	    if (proc) *proc=e->proc;
	    if (param) *param=e->param;
	    break;
        } else e=e->next;
    }
    return e;
}

int event_store(struct timeval *when, void (*proc)(void *,struct timeval *),
								void *param)
{
    event *e,**t=&event_anchor;

    if ((!when) || (!proc)) return -1;
    e=(event *)malloc(sizeof(event));
    e->when= *when;
    e->proc=proc;
    e->param=param;
    e->new=1;
    while(*t && TIMCOMP(e->when,(*t)->when)) t=&((*t)->next);
    e->next=*t;
    *t=e;
    return 0;
}

int event_remove(struct timeval *when, void (*proc)(void *,struct timeval *),
								void *param)
{
    event *e,**t=&event_anchor;
    int cnt=0;

    while(*t) {
	if ((when==NULL  || (when->tv_sec==(*t)->when.tv_sec &&
			   when->tv_usec==(*t)->when.tv_usec))  &&
            (proc==NULL  || proc==(*t)->proc)                  &&
	    (param==NULL || param==(*t)->param)) {
            cnt++;
	    e=*t;
	    *t=(*t)->next;
            free(e);
        } else t=&((*t)->next);
    }
    return cnt;
}

struct timeval *event_ripe_handle_time(int *acted)
{
    static int in_handler;
    static struct timeval etim;
    event *e,**t;

    *acted=0;
    if (!event_anchor) return NULL;

    if (in_handler) {
	/* this is not fatal, but a bad idea */
	/* aehm.. this CAN be fatal, as the same event can be processed
	 * and freed twice! */
      fprintf(stderr,"event_ripe_handle_time called itself! This is baaaad!");
      abort();
    }
    in_handler=1;

    for(t=&event_anchor;*t;t=&((*t)->next)) (*t)->new=0;
    gettimeofday(&etim,NULL);
    t=&event_anchor;
    *acted=0;
    while(*t && TIMCOMP(etim,(*t)->when)) {
	if (!(*t)->new) {
	    e=*t;
	    *t=(*t)->next;
	    e->proc(e->param,&(e->when));
	    (*acted)++;
	    free(e);
	    t=&event_anchor; /* list may be modfied! */
	    gettimeofday(&etim,NULL); /* how long did it take ;-) */
	    continue;
	}
	t=&((*t)->next);
    }
    in_handler=0;
    /* find the next one, including new ones! */
    t=&event_anchor;
    /* for(t=&event_anchor;*t && TIMCOMP(etim,(*t)->when);t=&((*t)->next)) ; */
    /* I really do not know why this loop is here. This is a BUG! If an event
     * is in the queue, stores a new event when being called, and then takes
     * long enough to complete, such that the starting time of the NEW event
     * is already in the past, the NEW event will never be called.
     * This because above loop hopps over all 'decayed' events, altough they
     * have not yet been handled. /gec 19.2.96 
     */
    if (*t) {
	etim.tv_sec=(*t)->when.tv_sec-etim.tv_sec;
	etim.tv_usec=(*t)->when.tv_usec-etim.tv_usec;
	if (etim.tv_usec <0) {
	    etim.tv_sec--;
	    etim.tv_usec+=1000000;
	}
	if (etim.tv_sec < 0) etim.tv_sec=etim.tv_usec=0;
	return &etim;
    } 
    return NULL;
}

