/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/* cert_event.h (c) by G. Caronni in 1995            18.11.95 */

#ifndef CERT_EVENT__H
#define CERT_EVENT__H


extern void *
event_find(void *next, struct timeval **when, 
	     void (**proc)(void *,struct timeval *),
	     void **param);
/*
 * Allows searching for an event. Parameters are returned in arguments.
 * By calling this this with next = previous return value the search 
 * resumes where it returned from last time. Take care not to event_remove
 * the element 'next' (which is the one you just found).
 */

extern int 
event_store(struct timeval *when, 
 	    void (*proc)(void *,struct timeval *),
	    void *param);
/*
 * Stores an event in the queue. Returns 0 if ok, -1 on failure
 * 'When' shall be the gettimeofday() on which execution shall start.
 */

extern int 
event_remove(struct timeval *when, 
	     void (*proc)(void *,struct timeval *),
	     void *param);
/*
 * Removes events from the queue that match the three passed parameters. 
 * A parameter of value NULL matches always.
 * Returns number of events that were removed.
 * (event_remove(NULL,NULL,NULL) removes all events)
 */

extern struct timeval *
event_ripe_handle_time(int *acted);
/*
 * Calls the events that are ripe, removes them from the queue. Returns
 * a timeval, which contains the time for which the next event is sheduled.
 * the time is relative to the actual gettimeofday()
 * Returns NULL if there are no pending events.
 * acted is set to the number of events that were called 
 * You may not call this funtion while called by this function.
 */

extern int event_init(void);
extern void event_exit(void);
#endif
