#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <assert.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>


#include "cert_defs.h"
#include "cert_db.h"
#include "cert_int.h"
#include "md5.h"

#ifdef __GNUC__
#ident "$Id: cert_make.c,v 1.4 1996/04/25 14:54:20 hauber Exp $"
#else
static char rcsid[] = "$Id: cert_make.c,v 1.4 1996/04/25 14:54:20 hauber Exp $";
#endif


int make_cert_08(dh_data *find, u_char *buf) 
{
    u_char *raw, *t=buf;
    int l;

    *(u_long *)t=htonl(find->begins);
    t+=sizeof(u_long);
    *(u_long *)t=htonl(find->expires);
    t+=sizeof(u_long);
    l=int_extract_raw(&raw,find->p,0); assert(l<65536);
    *t++=l>>8;
    *t++=l&0xff;
    memcpy(t,raw,l);
    t+=l;
    free(raw);
    /* from now on, alignment is not guaranteed */
    l=int_extract_raw(&raw,find->g,0); assert(l<65536);
    *t++=l>>8;
    *t++=l&0xff;
    memcpy(t,raw,l);
    t+=l;
    free(raw);
    l=int_extract_raw(&raw,find->ki,0); assert(l<65536);
    *t++=l>>8;
    *t++=l&0xff;
    memcpy(t,raw,l);
    t+=l;
    free(raw);

    return t-buf;
}


void main(int argc, char *argv[])
{
    dh_data *data;
    u_char buf[1024];
    int bytes_len;
    u_char md5[16];
    struct MD5Context ctxt;
    int i;

    if (argc != 2 || access(argv[1],R_OK) != 0) {
        fprintf(stderr,"Usage: %s secret-file\n",argv[0]);
        exit(-1);
    }

    assert(!db_init());

    assert(!int_mathinit());

    data=db_secret_read(argv[1]);

    if (!data) {
	fprintf(stderr,"Could not read secret data from %s\n",argv[1]);
        fprintf(stderr,"Aborting...\n");
        exit(-2);
    }

    assert(data->g && data->p && data->j);
    assert(!data->ki);

    int_init(&(data->ki));

    int_modexp(data->ki,data->g,data->j,data->p);

    bytes_len=make_cert_08(data, buf);

    cert_MD5Init(&ctxt);
    cert_MD5Update(&ctxt,buf,bytes_len);
    cert_MD5Final(md5,&ctxt);

    db_public_write(stdout, data, "<???>", "<cert_make>");
    printf("#MD5 of public value\n");
    for(i=0;i<16;i++) printf("%02X",md5[i]);
    printf("\n");

    db_cert_drop(data);
    exit(0);
}

