/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/* (c) by G. Caronni in 1995                    19.11.95 */
/* Rewritten. Robert Muchsel 1996                        */

#ifndef CERT_UDP__H
#define CERT_UDP__H

extern int send_socket;
extern int recv_socket;

extern int udp_init(void);
extern void udp_exit(void);

extern void udp_process_requestor(int);
extern void udp_process_responder(int);

void udp_request(u_long, u_char, u_char *, u_char, u_char *);

#define CDP_VERSION	1

typedef struct {
  u_char version;
  u_char action;
  u_char num_recs;
  u_char reserved;
  u_long req_cookie;
  u_long resp_cookie;
} cdp_header;

typedef struct {
  u_char action;
  u_char name_type;
  u_char name_len;
  u_char name[0];
} cdp_record;

typedef struct {
  u_char cert_type;
  u_char cert_len[2];
  u_char cert[0];
} cdp_cert;

#define CDP_REQUEST		0
#define CDP_RESPONSE		1
#define CDP_COOKIE_REQUIRED	2
#define CDP_REQUEST_TOO_LARGE	3

#define CDP_REC_GET		1
#define CDP_REC_PUT		2

#define CDP_REC_GET_OK		100
#define CDP_REC_GET_FAIL	101
#define CDP_REC_PUT_OK		102
#define CDP_REC_PUT_FAIL	103

#define CDP_NAME_SKIP		1	/* nsid + mkid */
#define CDP_NAME_PGP_STRING	2
#define CDP_NAME_PGP_KEYID	3
#define CDP_NAME_DNS		4
#define CDP_NAME_RFC822		5
#define CDP_NAME_X509		6

#define CDP_CERT_X509		1
#define CDP_CERT_PGP		2
#define CDP_CERT_DNS		3
#define CDP_CERT_DH_PUBLIC	4
#define CDP_CERT_EC_PUBLIC	5
#define CDP_CERT_RSA_PUBLIC	6
#define CDP_CERT_X509_REVOCATE	7

#endif				/* CERT_UDP__H */

