#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <iostream.h>

#include "../bn/bn.h"

#include <Bstream.h>
#include <Bigint.h>
#include <SkipCert.h>
#include <bn_glue.h>

#include "enlink.h"


void enlink_drop(void *cert)
{
    SkipCert *c = (SkipCert *) cert;

    c -> ~SkipCert();
}


void *enlink_readhex(char *buf, int len)
{
    SkipCert *cert;
    int type,i,rlen=len/2-4;
    Bstream in;
    char *t=buf;
    u_char *r,*raw= (byte *) malloc(len);

    r=raw;
    while(len) {
	if (*t >= '0' && *t <= '9') i= *t-'0';
	else if (*t >= 'A' && *t <= 'Z') i= *t-'A'+10;
	else if (*t >= 'a' && *t <= 'z') i= *t-'a'+10;
	else {
	    free(raw);
	    return NULL;
	}
	i *= 16;
	t++;
	len--;

	if (*t >= '0' && *t <= '9') i+= *t-'0';
	else if (*t >= 'A' && *t <= 'Z') i+= *t-'A'+10;
	else if (*t >= 'a' && *t <= 'z') i+= *t-'a'+10;
	else {
	    free(raw);
	    return NULL;
	}
	t++;
        *r++ = i;
	len--;
    }
    type = * (int *) raw;
    in = Bstream(rlen, raw+4);
    cert = decode_SkipCert(type, in);
    // cert->print(); // XXX debug
    free(raw);
    return (void *) cert;
}


void *enlink_readudp(char *buf)
{
    SkipCert *cert;
    Bstream x;
    int len;

    len = *buf * 256 + buf[1];
    x = Bstream(len, (u_char *) buf + 2);
    cert = decode_SkipCert(*buf, x);
    // cert->print();
    return (void *) cert;
}

void *enlink_readfile(int type, char *fname)
{
    SkipCert *cert;
    Bstream x;

    x=File_to_Bstr(fname);
    if (x.getlength() == 0) {
	fprintf(stderr, "Certificate %s not found\n", fname);
	return NULL;
    }
    cert = decode_SkipCert(type, x);
    // cert->print();
    return (void *) cert;
}


int enlink_saveudp(char *buf,void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    Bstream out;
    char *base = buf;

    *buf++ = c->CertType;
    out = c->encode();
    *buf++ = out.getlength() >> 8;
    *buf++ = out.getlength() & 0xff;
    memcpy(buf, out.getdatap(), out.getlength());
    buf += out.getlength();
    return buf-base;
}

int enlink_validate(void /* char *name, int namlen, void *cert */)
{

    return 0;
}


int enlink_savehex(FILE *f, void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    Bstream out;
    u_char *base;
    int len,i;

    out = Bstream(4, (u_char *) &(c->CertType));
    out += c->encode();
    base = out.getdatap();
    len = out.getlength();
    fprintf(f,"%d\n",len*2);
    while(len>35) {
	for(i=0;i<35;i++) fprintf(f,"%02x",*base++);
	fprintf(f,"\\\n");
	len -= 35;
    }
    for(i=0;i<len;i++) fprintf(f,"%02x",*base++);
    fprintf(f,"\n");
    return -1;
}


u_long enlink_getbefore(void *cert)
{
    SkipCert *c = (SkipCert *) cert;

    return c->skip_notvalidbefore();
}


u_long enlink_getafter(void *cert)
{
    SkipCert *c = (SkipCert *) cert;

    return c->skip_notvalidafter();
}


struct BigNum *enlink_getg(void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    struct BigNum *n = (struct BigNum *) malloc(sizeof(struct BigNum));
    Bstream ns;
    Bigint g, p;

    bnBegin(n);
    c->skip_params(g,p);
    Bigint_to_BigNum(&g,n);
    return n;
}


struct BigNum *enlink_getp(void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    struct BigNum *n = (struct BigNum *) malloc(sizeof(struct BigNum));
    Bstream ns;
    Bigint g, p;

    bnBegin(n);
    c->skip_params(g,p);
    Bigint_to_BigNum(&p,n);
    return n;
}


struct BigNum *enlink_geti(void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    struct BigNum *n = (struct BigNum *) malloc(sizeof(struct BigNum));
    Bstream ns;
    Bigint p=c->skip_pubkey();

    bnBegin(n);
    Bigint_to_BigNum(&p,n);
    return n;
}


char *enlink_getname(void *cert)
{
    SkipCert *c = (SkipCert *) cert;
    char *ret;
    Bstream nam=c->skip_name();

    if (!nam.getlength()) return NULL;
    ret = (char *) malloc(nam.getlength());
    memcpy(ret,nam.getdatap(),nam.getlength());
    return ret;
}
