#include <sys/types.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>


#include "../bn/bn.h"
#include "enlink.h"

static char *extract_hex(struct BigNum *mpi)
{
    int len,i;
    unsigned char *raw, *s;
    char *buf, *t;
 
    len=bnBits(mpi);
    len=(len+7)/8;
    raw=(unsigned char *)malloc(len);
    memset(raw,0,len);
    bnExtractBigBytes(mpi, raw, 0, len);

    buf=(char *)malloc(2*len+1);
    for(t=buf,s=raw,i=0;i<len;i++,t+=2,s++) sprintf(t,"%.2X",*s);
    free(raw);
    return buf;
}


void usage(char *prog)
{
    fprintf(stderr, "Usage: %s X.509-certificate-file secret_i-file\n", prog);
    fprintf(stderr, "       produces ENskip public and secret file on ");
    fprintf(stderr, "stdout.\n");
    exit(1);
}

	
int main(int argc, char *argv[])
{
    u_long before, after;
    void *pnum, *gnum, *inum;
    int i,j;
    u_char *mkid;
    time_t tim=time(NULL);
    u_char buf[1024], *ut;

    char *hex,*t;


    void *cert;
    int type = 1; /* X.509 */

    if (argc != 3) usage(argv[0]);

    bnInit();

    cert=enlink_readfile(type, argv[1]);
    if (!cert) {
	fprintf(stderr, "Cert not loaded!\n\n");
	usage(argv[0]);
    }
    pnum=enlink_getp(cert);
    gnum=enlink_getg(cert);
    inum=enlink_geti(cert);
/*
    before=enlink_getbefore(cert) - 2208988800ul;
    after=enlink_getafter(cert) - 2208988800ul;
 */
    before=enlink_getbefore(cert);
    after=enlink_getafter(cert);
    mkid=enlink_getname(cert);
    
    /* print public certificate in ENskip notation (clone cert_make) */

    printf("#Public value for <%d.%d.%d.%d>\n",
					    mkid[0],mkid[1],mkid[2],mkid[3]);
    printf("#provided by <sun2en>\n#%s\n",ctime(&tim));
    printf("#valid since (NTP)\n%08X\n\n",(u_int)before);
    printf("#valid until (NTP)\n%08X\n\n",(u_int)after);
    printf("#Base g (hex)\n");
    hex=extract_hex(gnum);
    for(t=hex;strlen(t)>70;t+=70) printf("%.70s\\\n", t);
    printf("%s\n\n",t);
    free(hex);
    printf("#Modulus p (hex)\n");
    hex=extract_hex(pnum);
    for(t=hex;strlen(t)>70;t+=70) printf("%.70s\\\n", t);
    printf("%s\n\n",t);
    free(hex);
    printf("#Public Value (hex)\n");
    hex=extract_hex(inum);
    for(t=hex;strlen(t)>70;t+=70) printf("%.70s\\\n", t);
    printf("%s\n\n",t);
    free(hex);
    printf("#Certificate Data\n");
    enlink_savehex(stdout,cert);

    /* print secret DH file in ENskip notation */

    i=open(argv[2], O_RDONLY);
    if (i>=0) { 
        printf("\n\n#Secret Value i\n");
	j=read(i,buf,sizeof(buf));
	close(i);
	ut=buf;
	while(j>35) {
	    for(i=0;i<35;i++) printf("%02x",*ut++);
	    printf("\\\n");
	    j -= 35;
	}
	for(i=0;i<j;i++) printf("%02x",*ut++);
	printf("\n\n");
    } else {
	fprintf(stderr, "Could no open secret value %s!\n\n",argv[2]);
	usage(argv[0]);
    }

    free(mkid);
    bnEnd(pnum);
    bnEnd(gnum);
    bnEnd(inum);
    free(pnum);
    free(gnum);
    free(inum);
    enlink_drop(cert);

    return 0;
}
