#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main(int argc, char *argv[])
{
  if (argc > 1)
  {
    int s;
    struct sockaddr_in sin;

    if ((s = socket(PF_INET, SOCK_STREAM, 0)) < 0)
      return 1;

    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = inet_addr(argv[1]);
    sin.sin_port = htons((argc > 2) ? atoi(argv[2]) : 23);

    if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
    {
      close(s);
      return 1;
    }

    for (;;)
    {
      fd_set in;
      int r;

      FD_ZERO(&in);
      FD_SET(s, &in); FD_SET(fileno(stdin), &in);

      r = select(s + 1, &in, NULL, NULL, NULL);

      if (r > 0)
      {
	char buf[1024];

        if (FD_ISSET(s, &in))
	{
          r = read(s, buf, sizeof(buf));
          if (r <= 0)
            break;

          write(fileno(stdout), buf, r);
	}
        if (FD_ISSET(fileno(stdin), &in))
	{
	  r = read(fileno(stdin), buf, sizeof(buf));
	  write(s, buf, r);
	}
      }
    }
    shutdown(s, 2);
    close(s);
  }

  return 0;
}
