/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni, R. Muchsel
 * See COPYING for more details
 */
/*
 * Magic number defining supported algorithms
 */
#define CRYPTALG_UNKNOWN       0

#define CRYPTALG_DES           1 /* DES-CBC block cipher (56 bit key)       */
#define CRYPTALG_3DES_3        2 /* 3 key Triple-DES-CBC block cipher       */
#define CRYPTALG_IDEA          3 /* IDEA-CBC block cipher (128 bit key)     */
#define CRYPTALG_3DES_2      230 /* 2 key Triple-DES-CBC block cipher   XXX */
#define CRYPTALG_RC4_40      240 /* RC4 stream cipher (40 bit key)          */
#define CRYPTALG_SAFER_SK128 241 /* SAFER SK-128 CBC block cipher           */
#define CRYPTALG_RC2_40      242 /* RC2-CBC block cipher (40 bit key)       */
#define CRYPTALG_RC4_128     243 /* RC4 stream cipher (128 bit key)         */
#define CRYPTALG_RC2_128     244 /* RC2-CBC block cipher (128 bit key)      */
#define CRYPTALG_SIMPLE      252 /* Sun Simple Crypt (64 bit key)           */

#define CRYPTALG_MAX         256 /* Used to query maximum lengths           */
#define CRYPTALG_MAXBLOCK    257 /* Query maximum lengths for block ciphers */

#define MEMEOR(dst,src,len) { int _i = len; while (_i--) dst[_i] ^= src[_i]; }
#define MAXBLOCKLEN	       8 /* watch out for kernel stack problems if larger */
#define MAXKEYLEN	      24 /* XXX: MUST be multiple of MAXBLOCKLEN! */

/*
 * Public interface to algorithms
 */
extern int crypt_init(void);  /* Initialize all crypt algorithms */
extern int crypt_exit(void);  /* Cleanup all crypt algorithms */

extern int crypt_encryptstatelen(int alg); /* Get algo encrypt state len   */
extern int crypt_decryptstatelen(int alg); /* Get algo encrypt state len   */
extern int crypt_blocklen(int alg);        /* Get algorithm data block len */
extern int crypt_keylen(int alg);          /* Get algorithm key len        */
extern int crypt_MIlen(int alg);           /* Get algorithm MI len         */

/* It is legal to have in & out to be same memblk for en-/decrypt */
extern int crypt_encrypt(int alg, u_char *state, u_char *key,
			 u_char *oldMI, u_char *newMI,
                         struct memblk *in, struct memblk *out);
extern int crypt_decrypt(int alg, u_char *state, u_char *key, u_char *MI,
                         struct memblk *in, struct memblk *out);

/*
 * Internal definition of an algorithm
 */
struct crypt_algorithm
{
  int (*init)(void);             /* Initialization */
  int (*exit)(void);             /* Cleanup */
  int (*encryptstatelen)(void);  /* Len of encrypt state */
  int (*decryptstatelen)(void);  /* Len of decrypt state */
  int (*blocklen)(void);         /* Len of data block for cipher (stream: 1) */
  int (*keylen)(void);           /* Len of key */
  int (*MIlen)(void);            /* Len of Initialization Vector IV */
  int (*setencryptkey)(u_char *key, u_char *state);
  int (*setdecryptkey)(u_char *key, u_char *state);
  int (*encrypt)(u_char *in, u_char *out, int len, u_char *state);
  int (*decrypt)(u_char *in, u_char *out, int len, u_char *state);
  int (*streamfastforward)(u_char *state, u_int amount);
};
