/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */

#ifndef _ID__H
#define _ID__H


extern int nsid_len[];


typedef struct skip_id		/* Could be extended by protocol/port */
{
  u_char type[2];
  u_char id[2][SKIP_ID_MAXLEN];
} skip_id_t;

#ifndef KERNEL
int id_parseids(char *name, skip_id_t *id);
int id_saveids(FILE *f, skip_id_t *id);
int id_sprintids(char *buf, int buflen, skip_id_t *id);
int id_printhex(FILE *f, u_char *val, int len);
int id_sprinthex(char *s, u_char *val, int len);
int id_printnicehex(FILE *f, u_char *val, int len);
int id_scanhex(char *val, char *buf, int l);
#endif

#endif
