/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */

/* Get new cache entry */
#define SKIPREQ_GETENTRY	1

/* Kp expired/ is invalid, get new Kp or Kijn */
#define SKIPREQ_GETENSKIPKEY	2

/* Unknown encrypted Kp, daemon should decrypt it or give us Kijn */
#define SKIPREQ_GETDESKIPKEY	3

/* Update messages from daemon to kernel */
#define SKIPREQ_UPDATEENTRY     4
#define SKIPREQ_UPDATEKIJN      5
#define SKIPREQ_UPDATEENSKIPKP  6
#define SKIPREQ_UPDATEDESKIPKP  7

/* Control and statistics messages from daemon to kernel */
#define SKIPREQ_GETREQUESTS	11
#define SKIPREQ_REMOVEENTRY     12
#define SKIPREQ_REGISTER        13
#define SKIPREQ_FLUSH           14
#define SKIPREQ_STATCACHE       15
#define SKIPREQ_STATIPSP        16
#define SKIPREQ_ATTACH		17
#define SKIPREQ_DETACH		18
#define SKIPREQ_DUMP		19
#define SKIPREQ_LISTCACHE	20

#define SKIPREQ_TEST		21

struct skipreq_hdr
{
  int req;
  skip_id_t id;

  u_char srcip[IPADDRSIZE], dstip[IPADDRSIZE];
};

struct skipreq_getentry
{
  struct skipreq_hdr hdr;
};

struct skipreq_getenskipkey
{
  struct skipreq_hdr hdr;
  int Kij_alg;
  u_char Kp[MAXKEYLEN];
};

struct skipreq_getdeskipkey
{
  struct skipreq_hdr hdr;
  u_int32 n;
  int Kij_alg;
  u_char Kp_Kijn[MAXKEYLEN];
};

struct skipreq_updateentry
{
  struct skipreq_hdr hdr, oldhdr;
  struct skipcache entry;
};

struct skipreq_updateKp
{
  struct skipreq_hdr hdr, oldhdr;
  u_int32 n;
  int Kij_alg;
  u_long A_Kplen, E_Kplen, Kp_Kijnlen;
  u_char A_Kp[SKIP_KP_LEN], E_Kp[SKIP_KP_LEN], Kp_Kijn[MAXKEYLEN];
};

struct skipreq_updateKijn
{
  struct skipreq_hdr hdr, oldhdr;
  u_int32 n;
  int keyttl;
  u_char Kijn[3][MAXKEYLEN];
};

struct skipreq_statcache
{
  struct skipreq_hdr hdr;
  struct skipcache_stat stat;
};

struct skipreq_statipsp
{
  struct skipreq_hdr hdr;
  struct ipsp_stat stat;
};

struct skipreq_register
{
  struct skipreq_hdr hdr;
  pid_t pid;
};

struct skipreq_listcache
{
  u_int hash_depth[HASHTBLSIZE];   /* per slot usage */
  u_int cache_maxentries; 	   /* maximum number of allowed entries */
  u_int cache_entries;             /* number of returned entries */

  skip_id_t entry[1]; 		   /* this array has variable size, 
		       		    * depending on number of entries */
};

extern int req_handle(u_char *req, int len);
