/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/*
 * Magic number defining supported algorithms
 */
#define SIGN_KEYLEN	16	/* XXX: We use 128 bit keys */

#define SIGNALG_UNKNOWN	0
#define SIGNALG_MD5	1 	/* MD5 message digest */
#define SIGNALG_MAX	2	/* Used to query maximum lengths XXX for now */
#define SIGNALG_DES_CBC 2	/* DES CBC */
#define SIGNALG_SHA	3	/* SHA message digest */

/*
 * Public interface to algorithms
 */
extern int sign_init(void);		/* Initialize all crypt algorithms */
extern int sign_exit(void);		/* Cleanup all crypt algorithms */

extern int sign_icvlen(int alg);	/* Get algorithm private data len */
extern int sign_sign(int alg, u_char *Kp, int Kplen, struct memblk *m,
                     u_char *icv);

/*
 * Internal definition of an algorithm
 */
struct sign_algorithm
{
  int (*init)(void);        /* Initialization */
  int (*exit)(void);        /* Cleanup */
  /* sign sumbitted data */
  int (*sign)(u_char *Kp, int Kplen, struct memblk *m, u_char *icv);
  /* length of calculated icv */
  int (*icvlen)(void);
};

