/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"
#include <sys/proc.h>

#ifdef __GNUC__
#ident "$Id: com.c,v 1.6 1996/04/25 14:57:22 hauber Exp $"
#else
static char rcsid[] = "$Id: com.c,v 1.6 1996/04/25 14:57:22 hauber Exp $";
#endif

static void *daemonproc;

int com_register(pid_t pid)
{
  if (daemonproc)  /* Release previous proc if present */
    proc_unref(daemonproc);

  daemonproc = proc_ref();

  return 0;
}

int com_unregister(void)
{
  void *proc = proc_ref();

  if (proc == daemonproc)
  {
    daemonproc = NULL;
    proc_unref(proc);
  }

  proc_unref(proc);
}

int com_signal(int sig)
{
  if (daemonproc)
    proc_signal(daemonproc, sig);

  return 0;
}
