/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/*
 * All system depending ressources are defined as a macro in this file
 */

#define CERTDIR		"/opt/skip"
#define CONFIGFILE	"/etc/skipd.conf"
#define LOGFILE		"/var/log/skipd.log"

#ifdef KERNEL
#define _KERNEL 1
#endif /* KERNEL */

#include <sys/types.h>

/*
 * some functions to convert values from network byte order and inverse
 */
#include <sys/param.h>

typedef int int32;
typedef u_int u_int32;
typedef u_short u_int16;
typedef u_char u_int8;

#include <sys/endian.h>

#define SKIP_HTONL(x)		htonl(x)
#define SKIP_NTOHL(x)		SKIP_HTONL((x))
#define SKIP_HTONS(x)		htons(x)
#define SKIP_NTOHS(x)		SKIP_HTONS((x))


#ifdef KERNEL

#include <sys/kmem.h>

#ifdef SKIP_ALLOCDEBUG
extern u_long skip_alloccount;

static void *skip_kalloc(size_t size)
{
  skip_alloccount++;
  return kmem_alloc(size, KM_NOSLEEP);
}

static void skip_kfree(void *ptr, size_t size)
{
  skip_alloccount--;
  kmem_free(ptr, size);
}

#define KALLOC(size)		skip_kalloc((size))
#define KFREE(ptr, size)	skip_kfree((ptr), (size)); (ptr) = (void *)0
#else
#define KALLOC(size)		kmem_alloc((size), KM_NOSLEEP)
#define KFREE(ptr, size)	kmem_free((ptr), (size)); (ptr) = (void *)0
#endif

#include <sys/systm.h>

/* MEMCMP should return 0, if areas match */
#define MEMCMP(a, b, size)	bcmp((caddr_t)(a), (caddr_t)(b), (size))
#define MEMCPY(to, from, size)	bcopy((caddr_t)(from), (caddr_t)(to), (size))
#define MEMZERO(a, size)	bzero((caddr_t)(a), (size))

#include <sys/ddi.h>
static int timeout_id;
#define TIMEOUT(func, arg, sec)	timeout_id = timeout((void *)(func), (arg), drv_usectohz(1000000 * (sec)))
#define UNTIMEOUT(func, arg)	untimeout(timeout_id)

#include <sys/sema.h>

static int skip_oldspl;

#define SEMTYPE			lock_t
#define SEMALLOC(s)		
#define SEMINIT(s)		initnlock(&s, "skiplock")
#define SEMLOCK(s)		skip_oldspl = io_splockspl(s, splimp)
#define SEMUNLOCK(s)		io_spunlockspl(s, skip_oldspl)
/*
 * SEMLOCKTRY should try to lock the semaphore
 * if the semaphore is locked 0 is returned.
 */
#define SEMLOCKTRY(s)		(SEMLOCK(s), 0)
#define SEMFREE(s)		SEMLOCK(s); SEMUNLOCK(s); freesplock(s);

#include <sys/sysinfo.h>
#include <sys/ksa.h>
extern struct ksa ksa;
#define SEEDTYPE		struct ksa
#define SEEDINIT(s)		MEMCPY((s), &ksa, sizeof(*(s)))

#include <sys/time.h>
static struct timeval _gmttv;
#define GMTSECONDS		(microtime(&_gmttv), _gmttv.tv_sec)
#endif /* KERNEL */

/*
 * type definition for queues in cache
 */
#include <sys/stream.h>
#include <sys/socket.h>
#include <sys/mbuf.h>
#include <net/if.h>

typedef struct ifqueue QUEUE;

extern int queue_free(void *x);
extern int queue_feed(void *x);
#define SKIP_FREEQ(x)		  queue_free((x))
#define SKIP_FEEDQ(x)		  queue_feed((x))

#ifndef NULL
#define NULL	(void *)0
#endif /* NULL */
