/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "queue.h"
#include "interface.h"

#ifdef __GNUC__
#ident "$Id: queue.c,v 1.6 1996/04/25 14:57:22 hauber Exp $"
#else
static char rcsid[] = "$Id: queue.c,v 1.6 1996/04/25 14:57:22 hauber Exp $";
#endif

/* XXX: Duplicated in interface.c, should be moved to some .h */
struct interface_fbparam
{
  struct ifnet *ifp;
  struct sockaddr_in address;
};

int queue_enqueuein(struct skipcache *c, void *interface, void *header,
                    void *pkt)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;

  if ((m = m_get(M_DONTWAIT, MT_DATA)))
  {
    m->m_len = sizeof(struct interface_fbparam);
    MEMCPY(mtod(m, void *), interface, sizeof(struct interface_fbparam));
    m->m_next = pkt;

    IFQ_LOCK(&q->inq);
    /* limit reached? */
    if ((q->inq.ifq_maxlen == 0) || (q->inq.ifq_len < q->inq.ifq_maxlen))
    {
      IF_ENQUEUE_NOLOCK(&q->inq, m);
      result = 0;
    }
    IFQ_UNLOCK(&q->inq);
  }

  return result;
}

int queue_enqueueout(struct skipcache *c, void *interface, void *header,
                     void *pkt)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;

  if ((m = m_get(M_DONTWAIT, MT_DATA)))
  {
    m->m_len = sizeof(struct interface_fbparam);
    MEMCPY(mtod(m, void *), interface, sizeof(struct interface_fbparam));
    m->m_next = pkt;

    IFQ_LOCK(&q->outq);
    /* limit reached? */
    if ((q->outq.ifq_maxlen == 0) || (q->outq.ifq_len < q->outq.ifq_maxlen))
    {
      IF_ENQUEUE_NOLOCK(&q->outq, m);
      result = 0;
    }
    IFQ_UNLOCK(&q->outq);
  }

  return result;
}

int queue_free(void *cptr)
{
  struct skipcache *c = (struct skipcache *)cptr;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;

  IFQ_LOCK(&q->outq);
  while (q->outq.ifq_head)
  {
    IF_DEQUEUE_NOLOCK(&q->outq, m);
    m_freem(m);
  }
  IFQ_UNLOCK(&q->outq);

  IFQ_LOCK(&q->inq);
  while (q->inq.ifq_head)
  {
    IF_DEQUEUE_NOLOCK(&q->inq, m);
    m_freem(m);
  }
  IFQ_UNLOCK(&q->inq);

  return 0;
}

int queue_feed(void *cptr)
{
  struct skipcache *c = (struct skipcache *)cptr;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *in, *out;
  int old;

  IFQ_LOCK(&q->inq);
  in = q->inq.ifq_head;
  q->inq.ifq_head = q->inq.ifq_tail = NULL;
  q->inq.ifq_len = 0;
  IFQ_UNLOCK(&q->inq);
  IFQ_LOCK(&q->outq);
  out = q->outq.ifq_head;
  q->outq.ifq_head = q->outq.ifq_tail = NULL;
  q->outq.ifq_len = 0;
  IFQ_UNLOCK(&q->outq);

  while (in)
  {
    struct mbuf *next = in->m_act;
    in->m_act = NULL;
    interface_infeedback(in);
    in = next;
  };

  while (out)
  {
    struct mbuf *next = out->m_act;
    out->m_act = NULL;
    interface_outfeedback(out);
    out = next;
  };

  return 0;
}

int queue_getips(struct skipcache *c, u_char *srcip, u_char *dstip)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;

  MEMZERO(srcip, IPADDRSIZE);
  MEMZERO(dstip, IPADDRSIZE);

  if ((m = q->inq.ifq_head) == NULL)
    m = q->outq.ifq_head;

  if (m)
  {
    struct ip *ip = mtod(m->m_next, struct ip *);

    MEMCPY(srcip, &ip->ip_src, sizeof(ip->ip_src));
    MEMCPY(dstip, &ip->ip_dst, sizeof(ip->ip_dst));
    result = 0;
  }

  return result;
}

int queue_initqueues(struct skipcache *c)
{
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

  IFQ_INITLOCK(&q->inq);
  IFQ_INITLOCK(&q->outq);
  q->inq.ifq_maxlen = QUEUESIZE;
  q->outq.ifq_maxlen = QUEUESIZE;
  return 0;
}

int queue_init(void)
{
  return 0;
}

int queue_exit(void)
{
  return 0;
}
