/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include "ipsum.h"

#ifdef __GNUC__
#ident "$Id: ipsum.c,v 1.6 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: ipsum.c,v 1.6 1996/04/25 15:05:30 cschneid Exp $";
#endif

/*
 * routine used to emulate the assembler command addc
 */
static u_short addc(u_short val, u_short sum)
{
  if ((unsigned int)(val + sum) > 0xffff)
    sum++;      /* overflow */
  sum += val;
  return sum;
}

/*
 * calculate ip checksum
 */
u_short ipsum(struct ip *h)
{
  u_short *ips = (u_short *)h;
  u_short ck = 0, old = h->ip_sum;
  short len = (h->ip_hl * 4);

  h->ip_sum = 0;
  for (; len > 1; len -= 2)
    ck = addc(SKIP_NTOHS(*ips++), ck);
  h->ip_sum = old;

  if (len)
    ck = addc(SKIP_NTOHS(*ips) & 0xff00,ck);

  return (~ck);
}
