/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include "dynamic.h"

#ifdef __GNUC__
#ident "$Id: dynamic.c,v 1.3 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: dynamic.c,v 1.3 1996/04/25 15:05:30 cschneid Exp $";
#endif

int dynamic_copybuf2dyn(u_char *base, skip_dynamic_t *dst,
			u_char *buf, u_long len)
{
  int result = -1;

  if (dst->len >= len)
  {
    MEMCPY(base + dst->offset, buf, len);
    result = 0;
  }
  else
  {
    printf(">>dynamic_copybuf2dyn: overflow! src len = %lu, dst len = %lu\n",
	   len, dst->len);
  } 

  return result;
}

int dynamic_copydyn2buf(u_char *base, skip_dynamic_t *src,
			u_char *buf, u_long len)
{
  int result = -1;

  if (src->len <= len)
  {
    MEMCPY(buf, src->offset + base, src->len);
    result = 0;
  }
  else
    printf(">>dynamic_copydyn2buf: overflow! src len = %lu, dst len = %lu\n", src->len, len);

  return result;
}
