/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */


/* use deprecated - they may not work anymore!  /gec 5.12.95 */





/* The sophisticated routines to access memblks                 /gec 21.9.95 */
/* They assume that there is enough space, and everything is valid ;-)       */

#include "config.h"
#include "skip_defs.h"
#include "memblk.h"

#ifdef __GNUC__
#ident "$Id: memblk.c,v 1.5 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: memblk.c,v 1.5 1996/04/25 15:05:30 cschneid Exp $";
#endif

void blkaddchar(struct memblk *m, u_char ch)
{
    struct memseg *ms = m->ms;
    int seek = m->offset;


    while(seek >= ms->len) 
    {
	seek -= ms->len;
	ms++;
    }

    *(ms->ptr+seek) = ch;

    /*BLKINC(m,1);*/
    m->offset++;

}

u_char blkgetchar(struct memblk *m)
{
    struct memseg *ms = m->ms;
    int seek = m->offset;

    while(seek >= ms->len) 
    {
	seek -= ms->len;
	ms++;
    }

    BLKINC(m,1);

    return *(ms->ptr+seek);
}

/* Modifies dst to point after copied data */
int memblk_copy(struct memblk *dst, struct memblk *src)
{
  int datalen = (src->len < dst->len) ? src->len : dst->len;
  struct memseg *srcms = src->ms, *dstms = dst->ms;
  int srclen = srcms->len - src->offset;
  int dstlen = dstms->len - dst->offset;
  u_char *srcdata = srcms->ptr + src->offset;
  u_char *dstdata = dstms->ptr + dst->offset;

  dst->len -= datalen;	/* Reduce size of dst by amount used to copy */

  /* Manually copy from old to new packet */
  while (datalen > 0)
  {
    int len = (srclen < dstlen) ? srclen : dstlen;

    MEMCPY(dstdata, srcdata, len);

    srcdata += len;
    dstdata += len;
    datalen -= len;

    if (datalen)	/* Do not advance pointers if no data left to copy */
    {
      if ((srclen -= len) <= 0)
      {
        srcms++;
        srclen = srcms->len;
        srcdata = srcms->ptr;
      }

      if ((dstlen -= len) <= 0)
      {
        dstms++;
        dstlen = dstms->len;
        dstdata = dstms->ptr;
      }
    }
  }

  dst->ms = dstms;
  dst->offset = dstdata - dstms->ptr;

  return 0;
}
