/*
 * Copyright (C) 1995,1997 M. Hauber, Ch. Schneider, G. Caronni, R. Muchsel
 * See COPYING for more details
 */

#ifndef SKIP_MD5_H
#define SKIP_MD5_H

#define MD5_CTX_DIGEST_LEN 16

typedef struct MD5_CTX {
  u_int32 buf[4];
  u_int32 bits[2];
  unsigned char in[64];
  unsigned char digest[MD5_CTX_DIGEST_LEN];
} MD5_CTX;

void MD5Init(struct MD5_CTX *context);
void MD5Update(struct MD5_CTX *context, unsigned char const *buf,
	       unsigned len);
void MD5Final(struct MD5_CTX *context);

/*
 * This is needed to make RSAREF happy on some MS-DOS compilers.
 *
 * typedef struct MD5Context MD5_CTX;
 */

#endif /* !SKIP_MD5_H */
