/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "skip_defs.h"
#include "memblk.h"
#include "crypt.h"

#ifdef __GNUC__
#ident "$Id: streamtest.c,v 1.4 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: streamtest.c,v 1.4 1996/04/25 15:05:30 cschneid Exp $";
#endif

static void print(u_char *data, int len)
{
  int i;

  for (i = 0; i < len; i++)
    printf(" %02x", data[i]);
  printf("\n");
}

int main(int argc, char **argv)
{
  u_char data[] = "Dies ist ein testtext...";
  u_char key[] = "0123456789123456";
  u_char estate[4096];
  u_char eMI[8];
  u_char dstate[4096];
  u_char dMI[8];
  struct memseg ms;
  struct memblk m;

  printf("Org: %s\n", data);

  memset(estate, '\0', sizeof(estate));
  memset(eMI, '\0', sizeof(eMI));
  memset(dstate, '\0', sizeof(dstate));
  memset(dMI, '\0', sizeof(dMI));

  memset(&m, '\0', sizeof(m));
  memset(&ms, '\0', sizeof(ms));
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_encrypt(CRYPTALG_RC4, estate, key, eMI, &m);
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_encrypt(CRYPTALG_RC4, estate, key, eMI, &m);

  printf("Enc:");
  print(data, sizeof(data));

  memset(&m, '\0', sizeof(m));
  memset(&ms, '\0', sizeof(ms));
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_decrypt(CRYPTALG_RC4, dstate, key, dMI, &m);
  longlong_inc(dMI, sizeof(data) + 1);
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_decrypt(CRYPTALG_RC4, dstate, key, dMI, &m);
  memset(dMI, '\0', sizeof(dMI));
  longlong_inc(dMI, sizeof(data));
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_decrypt(CRYPTALG_RC4, dstate, key, dMI, &m);
  memset(key, '\0', sizeof(key));
  m.offset = 0;
  m.len = ms.len = sizeof(data);
  m.ms = &ms;
  ms.ptr = data;
  crypt_decrypt(CRYPTALG_RC4, dstate, key, dMI, &m);


  return 0;
}

#ifdef __svr4__  /* Solaris 2.x */
void *bcopy(void *from, void *to, int len)
{
  return memcpy(to, from, len);
}

int bcmp(void *a, void *b, int len)
{
  return memcmp(a, b, len);
}

void *bzero(void *a, int len)
{
  return memset(a, '\0', len);
}
#endif /* __svr4__ */
