/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include <stdio.h>
#include "config.h"
#include "skip_defs.h"
#include "skipcache.h"
#include "sequence.h"

#ifdef __GNUC__
#ident "$Id: seqtest.c,v 1.4 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: seqtest.c,v 1.4 1996/04/25 15:05:30 cschneid Exp $";
#endif

static void print(skip_seq_t seq)
{
  int i;

  for (i = 0; i < SKIP_SEQSIZE; i++)
    printf("%02x", seq[i]);
  printf("\n");
}

static void printhistory(struct sequence_history *h, u_char *hbuf)
{
  int i;

  printf("history: len = %d, index = %d, last = ", h->len, h->index);
  print(h->last);
  for (i = 0; i < h->len; i++)
    printf("%d", hbuf[i]);
  printf("\n");
}

static u_char *seqno(int no)
{
  static skip_seq_t seq;

  memset(seq, '\0', sizeof(seq));
  while (no-- > 0)
    sequence_inc(seq);

  return seq;
}

static void check(struct sequence_history *h, u_char *hbuf, int no)
{
  printf("check: %d: %d\n", no, sequence_check(h, hbuf, seqno(no)));
}

int main(int argc, char **argv)
{
  int i, j;
  struct sequence_history h;
  u_char hbuf[4096];

  memset(&h, '\0', sizeof(h));
  memset(hbuf, '\0', sizeof(hbuf));

  h.len = 10;

  printhistory(&h, hbuf);
  check(&h, hbuf, 5);
  check(&h, hbuf, 7);
  check(&h, hbuf, 5);
  check(&h, hbuf, 0);
  check(&h, hbuf, 10);
  check(&h, hbuf, 0);
  check(&h, hbuf, 1);
  check(&h, hbuf, 14);
  check(&h, hbuf, 5);
  check(&h, hbuf, 18);
  check(&h, hbuf, 5000);
  check(&h, hbuf, 18);
  check(&h, hbuf, 4998);
  printhistory(&h, hbuf);

  return 0;
}
