/*
 * Copyright (C) 1995,1997 M. Hauber, Ch. Schneider, G. Caronni, R. Muchsel
 * See COPYING for more details
 */
#include "config.h"
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "crypt.h"
#include "sign.h"
#include "signmd5.h"
#include "skipcache.h"
#include "random.h"

#ifdef __GNUC__
#ident "$Id: random.c,v 1.7 1996/04/25 15:05:30 cschneid Exp $"
#else
static char rcsid[] = "$Id: random.c,v 1.7 1996/04/25 15:05:30 cschneid Exp $";
#endif

/**************************************************************************
 * RC4 Implementation from Usenet source                                  *
 **************************************************************************/
 
typedef struct rc4_key
{
  unsigned char state[256];
  unsigned char x, y;
} rc4_key;

static SEMTYPE semaphore;
static rc4_key state;
 
static void rc4_setkey(unsigned char *keydata, int len, rc4_key *key)
{
  unsigned char i2, is, i2s, *state, *k;
  int i, i1;
 
  state = key->state;
  for (i = 0; i < 256; i++)
    *state++ = i;
 
  state = key->state;
  for (i = i1 = i2 = 0, k = keydata; i < 256; i++)
  {
    is = state[i];
    i2 += *k++ + is;
    i2s = state[i2];
    state[i] = i2s;
    state[i2] = is;
    
    if (++i1 >= len)
    {
      k = keydata;
      i1 = 0;
    }
  }
 
  key->x = key->y = 0;
}

static void rc4_crypt(unsigned char *src, unsigned char *dst, int len, rc4_key *
key)
{
  int i;
  unsigned char x, y, xs, ys, *state;
 
  x = key->x;
  y = key->y;
  state = key->state;
 
  for (i = 0; i < len; i++)
  {
    xs = state[++x];
    ys = state[y += xs];
    state[x] = ys;
    state[y] = xs;
    *dst++ = *src++ ^ state[(unsigned char)(xs + ys)];
  }
 
  key->x = x;
  key->y = y;
}

int random_hash(u_char *buf, int buflen, u_char *val, int vallen)
{
  int digestlen = sign_icvlen(SIGNALG_MD5);
  int len;
#ifdef SMALL_KERNEL_STACK
  u_char *hash;
  struct memblk *m;
  struct memseg ms;

  if ((hash = KALLOC(64)) == NULL)
    return -1;
  if ((m = KALLOC(sizeof(*m))) == NULL) {
    KFREE(hash, 64);
    return -1;
  }
#endif /* SMALL_KERNEL_STACK */

  for (len = 0; buflen > 0; len += digestlen, buflen -= digestlen)
  {
#ifndef SMALL_KERNEL_STACK
    struct memblk m;
    struct memseg ms;
    u_char hash[64];

    m.len = len;
    m.offset = 0;
    m.ms = &ms;
#else /* SMALL_KERNEL_STACK */
    m->len = len;
    m->offset = 0;
    m->ms = &ms;
#endif /* SMALL_KERNEL_STACK */
    ms.len = len;
    ms.ptr = buf;
#ifndef SMALL_KERNEL_STACK
    sign_sign(SIGNALG_MD5, val, vallen, &m, hash);
#else /* SMALL_KERNEL_STACK */
    sign_sign(SIGNALG_MD5, val, vallen, m, hash);
#endif /* SMALL_KERNEL_STACK */
    MEMCPY(buf + len, hash, (digestlen > buflen) ? buflen : digestlen);
  }

#ifdef SMALL_KERNEL_STACK
  KFREE(m, sizeof(*m));
  KFREE(hash, 64);
#endif /* SMALL_KERNEL_STACK */

  return 0;
}

int random_expandKp(u_char *Kp, int Kp_len, u_char *E_Kp, int E_Kp_len, 
		    u_char *A_Kp, int A_Kp_len, u_char cryptalg, u_char macalg)
{
#ifndef SMALL_KERNEL_STACK
  MD5_CTX md5template, md5ctx;
#else /* SMALL_KERNEL_STACK */
  MD5_CTX *md5template, *md5ctx;
#endif /* SMALL_KERNEL_STACK */
  char ch;

#ifdef SMALL_KERNEL_STACK
  if ((md5template = KALLOC(sizeof(*md5template))) == NULL)
    return -1;
  if ((md5ctx = KALLOC(sizeof(*md5ctx))) == NULL) {
    KFREE(md5ctx, sizeof(*md5ctx));
    return -1;
  }
#endif /* SMALL_KERNEL_STACK */

  /* Calc MD5 context of Kp only once */
#ifndef SMALL_KERNEL_STACK
  MD5Init(&md5template);
  MD5Update(&md5template, Kp, Kp_len);
#else /* SMALL_KERNEL_STACK */
  MD5Init(md5template);
  MD5Update(md5template, Kp, Kp_len);
#endif /* SMALL_KERNEL_STACK */
  
  /* Calculate E_Kp */
  if (E_Kp_len > MD5_CTX_DIGEST_LEN)
  {
    int len = E_Kp_len - MD5_CTX_DIGEST_LEN;

    /* Calc high order part of E_Kp */
#ifndef SMALL_KERNEL_STACK
    MEMCPY(&md5ctx, &md5template, sizeof(md5ctx));
#else /* SMALL_KERNEL_STACK */
    MEMCPY(md5ctx, md5template, sizeof(*md5ctx));
#endif /* SMALL_KERNEL_STACK */
    ch = cryptalg;
#ifndef SMALL_KERNEL_STACK
    MD5Update(&md5ctx, &ch, 1);
#else /* SMALL_KERNEL_STACK */
    MD5Update(md5ctx, &ch, 1);
#endif /* SMALL_KERNEL_STACK */
    ch = 2;
#ifndef SMALL_KERNEL_STACK
    MD5Update(&md5ctx, &ch, 1);
    MD5Final(&md5ctx);
#else /* SMALL_KERNEL_STACK */
    MD5Update(md5ctx, &ch, 1);
    MD5Final(md5ctx);
#endif /* SMALL_KERNEL_STACK */
    
#ifndef SMALL_KERNEL_STACK
    MEMCPY(E_Kp, md5ctx.digest + sizeof(md5ctx.digest) - len, len);
#else /* SMALL_KERNEL_STACK */
    MEMCPY(E_Kp, md5ctx->digest + MD5_CTX_DIGEST_LEN - len, len);
#endif /* SMALL_KERNEL_STACK */
    E_Kp += len;
    E_Kp_len = MD5_CTX_DIGEST_LEN;
  }
  
  /* Calc low order part of E_Kp */
#ifndef SMALL_KERNEL_STACK
  MEMCPY(&md5ctx, &md5template, sizeof(md5ctx));
#else /* SMALL_KERNEL_STACK */
  MEMCPY(md5ctx, md5template, sizeof(*md5ctx));
#endif /* SMALL_KERNEL_STACK */
  ch = cryptalg;
#ifndef SMALL_KERNEL_STACK
  MD5Update(&md5ctx, &ch, 1);
#else /* SMALL_KERNEL_STACK */
  MD5Update(md5ctx, &ch, 1);
#endif /* SMALL_KERNEL_STACK */
  ch = 0;
#ifndef SMALL_KERNEL_STACK
  MD5Update(&md5ctx, &ch, 1);
  MD5Final(&md5ctx);
#else /* SMALL_KERNEL_STACK */
  MD5Update(md5ctx, &ch, 1);
  MD5Final(md5ctx);
#endif /* SMALL_KERNEL_STACK */
  
#ifndef SMALL_KERNEL_STACK
  MEMCPY(E_Kp, md5ctx.digest + sizeof(md5ctx.digest) - E_Kp_len, E_Kp_len);
#else /* SMALL_KERNEL_STACK */
  MEMCPY(E_Kp, md5ctx->digest + MD5_CTX_DIGEST_LEN - E_Kp_len, E_Kp_len);
#endif /* SMALL_KERNEL_STACK */
  
  /* Calculate A_Kp */
  if (A_Kp_len > MD5_CTX_DIGEST_LEN)
  {
    int len = A_Kp_len - MD5_CTX_DIGEST_LEN;

    /* Calc high order part of E_Kp */
#ifndef SMALL_KERNEL_STACK
    MEMCPY(&md5ctx, &md5template, sizeof(md5ctx));
#else /* SMALL_KERNEL_STACK */
    MEMCPY(md5ctx, md5template, sizeof(*md5ctx));
#endif /* SMALL_KERNEL_STACK */
    ch = macalg;
#ifndef SMALL_KERNEL_STACK
    MD5Update(&md5ctx, &ch, 1);
#else /* SMALL_KERNEL_STACK */
    MD5Update(md5ctx, &ch, 1);
#endif /* SMALL_KERNEL_STACK */
    ch = 3;
#ifndef SMALL_KERNEL_STACK
    MD5Update(&md5ctx, &ch, 1);
    MD5Final(&md5ctx);
#else /* SMALL_KERNEL_STACK */
    MD5Update(md5ctx, &ch, 1);
    MD5Final(md5ctx);
#endif /* SMALL_KERNEL_STACK */
    
#ifndef SMALL_KERNEL_STACK
    MEMCPY(A_Kp, md5ctx.digest + sizeof(md5ctx.digest) - len, len);
#else /* SMALL_KERNEL_STACK */
    MEMCPY(A_Kp, md5ctx->digest + MD5_CTX_DIGEST_LEN - len, len);
#endif /* SMALL_KERNEL_STACK */
    A_Kp += len;
    A_Kp_len = MD5_CTX_DIGEST_LEN;
  }
  
  /* Calc low order part of E_Kp */
#ifndef SMALL_KERNEL_STACK
  MEMCPY(&md5ctx, &md5template, sizeof(md5ctx));
#else /* SMALL_KERNEL_STACK */
  MEMCPY(md5ctx, md5template, sizeof(*md5ctx));
#endif /* SMALL_KERNEL_STACK */
  ch = macalg;
#ifndef SMALL_KERNEL_STACK
  MD5Update(&md5ctx, &ch, 1);
#else /* SMALL_KERNEL_STACK */
  MD5Update(md5ctx, &ch, 1);
#endif /* SMALL_KERNEL_STACK */
  ch = 1;
#ifndef SMALL_KERNEL_STACK
  MD5Update(&md5ctx, &ch, 1);
  MD5Final(&md5ctx);
#else /* SMALL_KERNEL_STACK */
  MD5Update(md5ctx, &ch, 1);
  MD5Final(md5ctx);
#endif /* SMALL_KERNEL_STACK */
  
#ifndef SMALL_KERNEL_STACK
  MEMCPY(A_Kp, md5ctx.digest + sizeof(md5ctx.digest) - A_Kp_len, A_Kp_len);
#else /* SMALL_KERNEL_STACK */
  MEMCPY(A_Kp, md5ctx->digest + MD5_CTX_DIGEST_LEN - A_Kp_len, A_Kp_len);

  KFREE(md5ctx, sizeof(*md5ctx));
  KFREE(md5template, sizeof(*md5template));
#endif /* SMALL_KERNEL_STACK */

  return 0;
}

/*
 * Generate a random packet key Kp for given skipcache entry
 */
int random_randomKp(struct skipcache *c)
{
  if ((c->flags) & SKIP_VALIDKEY)
  {
#ifdef SMALL_KERNEL_STACK
    struct memblk *m;
#else
    struct memblk m;
#endif
    struct memseg ms;
    u_char MI[MAXBLOCKLEN];
    static u_char es[1024];  /* Encrypt state */

    int Kp_Kijn_keylen = c->enskip_Kp_Kijn.key.len;
    int Kij_keylen = crypt_keylen(c->enskip_Kij_alg);

#ifdef SMALL_KERNEL_STACK
    if ((m = KALLOC(sizeof(*m))) == NULL)
      return -1;
#endif /* SMALL_KERNEL_STACK */

    MEMZERO(MI, sizeof(MI));

    c->enskip_Kp_ttl = c->enskip_Kp_maxttl;
    c->enskip_Kp_bytes = 0;

    /* Randomize MI for block ciphers, set to 0 for stream ciphers */
    if (crypt_blocklen(c->enskip_Crypt_alg) > 1)
      random_random(c->data + c->enskip_MI.offset, c->enskip_MI.len);
    else
      MEMZERO(c->data + c->enskip_MI.offset, c->enskip_MI.len);

    random_random(c->data + c->enskip_Kp_Kijn.key.offset, Kp_Kijn_keylen);
    random_expandKp(c->data + c->enskip_Kp_Kijn.key.offset, Kp_Kijn_keylen,
		    c->data + c->enskip_E_Kp.offset, c->enskip_E_Kp.len,
		    c->data + c->enskip_A_Kp.offset, c->enskip_A_Kp.len,
		    c->enskip_Crypt_alg, c->enskip_MAC_alg);

#ifndef SMALL_KERNEL_STACK
    m.ms = &ms;
    m.len = Kp_Kijn_keylen;
    m.offset = 0;
#else /* SMALL_KERNEL_STACK */
    m->ms = &ms;
    m->len = Kp_Kijn_keylen;
    m->offset = 0;
#endif /* SMALL_KERNEL_STACK */
    ms.ptr = c->data + c->enskip_Kp_Kijn.key.offset;
    ms.len = Kp_Kijn_keylen;
    SEMLOCK(semaphore);                /* Protect encrypt state */
    crypt_encrypt(c->enskip_Kij_alg, es, 
		  c->data + c->Kijn[skip_n % 3].key.offset + 
		  c->Kijn[skip_n % 3].key.len - Kij_keylen,
#ifndef SMALL_KERNEL_STACK
		  MI, MI, &m, &m);
#else /* SMALL_KERNEL_STACK */
		  MI, MI, m, m);
#endif /* SMALL_KERNEL_STACK */
    SEMUNLOCK(semaphore);
    c->enskip_Kp_Kijn.n = skip_n;

#ifdef SMALL_KERNEL_STACK
    KFREE(m, sizeof(*m));
#endif /* SMALL_KERNEL_STACK */
  }

  return 0;
}

int random_init(void)
{
  SEEDTYPE seed;
  static u_char rc4seed[256];

  SEMALLOC(semaphore);
  SEMINIT(semaphore);
  SEEDINIT(&seed);
  random_hash(rc4seed, sizeof(rc4seed), (u_char *)&seed, sizeof(seed));
  MEMZERO(&seed, sizeof(seed));
  rc4_setkey(rc4seed, sizeof(rc4seed), &state);
  MEMZERO(rc4seed, sizeof(rc4seed));
  return 0;
}

int random_exit(void)
{
  SEMFREE(semaphore);
  return 0;
}

int random_random(u_char *buf, int len)
{
  SEMLOCK(semaphore);
  rc4_crypt(buf, buf, len, &state);
  SEMUNLOCK(semaphore);
  return 0;
}
