/*
   Copyright (C) 1996-1997 Robert Muchsel

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Please address all correspondence concerning the software to
   muchsel@acm.org.
*/

#include "config.h"
#include <linux/kernel.h>
#include <linux/firewall.h>
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "interface.h"
#include "com.h"
#include "crypt.h"
#include "req.h"

static int daemonpid = 0;

/* send sig signal to daemon */
int com_signal(int sig)
{
  int retval;

  if (daemonpid)
    retval = kill_proc(daemonpid, sig, 1);
  else
    retval = -1;

  return retval;
}

/* register pid of daemon */
int com_register(int pid)
{
  daemonpid = pid;

  return 0;
}
