/*
   Copyright (C) 1996-1997 Robert Muchsel

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Please address all correspondence concerning the software to
   muchsel@acm.org.
*/

#ifndef _ENSKIP_LINUX_CONFIG_H
#define _ENSKIP_LINUX_CONFIG_H

#define CERTDIR		"/etc/cert"
#define CONFIGFILE	"/etc/skipd.conf"
#define SKIP_DEV_NAME	"/dev/enskip"
#define LOGFILE		"/var/log/skipd.log"

#define HAVE_INET_ATON
#define HAVE_DEV_RANDOM

#define __BSD_SOURCE

#include <asm/types.h>
#include <sys/types.h>
#include <unistd.h>
#include <netinet/in.h>

typedef __s32 int32;
typedef __u32 u_int32;
typedef __u16 u_int16;
typedef __u8 u_int8;

#ifdef LOWFIRST
#define __LITTLE_ENDIAN__
#else
#define __BIG_ENDIAN__
#endif

#define TRANSPARENT_UDP_IN_INTERFACE
#define CAN_DO_SKIP_P_FLAGS

#define SKIP_HTONL(x)		htonl((x))
#define SKIP_NTOHL(x)		ntohl((x))
#define SKIP_HTONS(x)		htons((x))
#define SKIP_NTOHS(x)		ntohs((x))

#ifdef KERNEL
#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS 1
#endif
#include <linux/modversions.h>
#include <asm/system.h>
#include <linux/malloc.h>
#include <linux/string.h>
#include <sys/socket.h>
#include <net/if.h>
#include <net/ip.h>
#include <linux/skbuff.h>

#define SMALL_KERNEL_STACK

#define KALLOC(size)		kmalloc((size), GFP_ATOMIC)
#define KFREE(ptr, size)	{ kfree((ptr)); (ptr) = NULL; }

#define MEMCMP(a, b, size)	memcmp((a), (b), (size))
#define MEMCPY(to, from, size)	memcpy((to), (from), (size))
#define MEMZERO(a, size)	memset((a), 0, (size))

extern void timeout(void *, unsigned long, unsigned long);
extern void untimeout(void *, unsigned long);
#define TIMEOUT(func, arg, sec)	timeout((void *) (func), (unsigned long) (arg),\
                                        (unsigned long) (sec))
#define UNTIMEOUT(func, arg)	untimeout((void *) (func), (unsigned long) (arg))

#define SEMTYPE		        unsigned long
#define SEMALLOC(s)
#define SEMINIT(s)	  	
#define SEMLOCK(s)		{ save_flags(s); cli(); }
#define SEMUNLOCK(s)		restore_flags(s)
extern inline int down_try(SEMTYPE *s) { SEMLOCK(*s); return 0; }
#define SEMLOCKTRY(s)		down_try(&s)
#define SEMFREE(s)

#define SEEDTYPE                unsigned long
#define SEEDINIT(s)             *(s) = jiffies

#define GMTSECONDS		xtime.tv_sec

#define printf printk

struct queue {
  struct queue *next;
  struct sk_buff *pskb;
};
typedef struct queue_head {
  struct queue *first, *last;
  int len;
} QUEUE;
extern int queue_free(void *);
#define SKIP_FREEQ(x)		queue_free((x))
extern int queue_feed(void *);

#define MAXQLEN 20

#else /* !KERNEL */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#include <bsd/signal.h>
#include <sys/time.h>

#define KALLOC(size)		malloc((size))
#define KFREE(ptr, size)	{ free((ptr)); (ptr) = NULL; }

#define MEMCMP(a, b, size)	memcmp((a), (b), (size))
#define MEMCPY(to, from, size)	memcpy((to), (from), (size))
#define MEMZERO(a, size)	memset((a), 0, (size))

typedef void (*sighandler_t)(int);
#define TIMEOUT(func, arg, sec)	{ signal(SIGALRM, (sighandler_t) (func)); alarm((sec)); }
#define UNTIMEOUT(func, arg)	alarm(0)

/* no semaphores at user level */
#define SEMTYPE			int
#define SEMALLOC(s)		
#define SEMINIT(s)		s = 0  /* Avoid compiler warnings */
#define SEMLOCK(s)		
#define SEMUNLOCK(s)		
#define SEMLOCKTRY(s)		0
#define SEMFREE(s)		

#define SEEDTYPE		struct timeval
#define SEEDINIT(s)		gettimeofday((s), NULL)

#define GMTSECONDS              time(NULL)

#define SKIP_FREEQ(x)

#endif /* !KERNEL */

/* This is often wrongly defined as 98, so go and fix it */
#ifdef IPPROTO_ENCAP
#undef IPPROTO_ENCAP
#endif
#define IPPROTO_ENCAP 4

/* BSDisms */
#define ip_sum ip_csum
#define uh_sport source
#define uh_dport dest

#endif /* _ENSKIP_LINUX_CONFIG_H */
