/*
   Copyright (C) 1996-1997 Robert Muchsel

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Please address all correspondence concerning the software to
   muchsel@acm.org.
*/

#include "config.h"
#define __NO_VERSION__
#include <linux/module.h>
#include <linux/version.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/ptrace.h>
#include <linux/malloc.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/interrupt.h>
#include <linux/in.h>
#include <linux/delay.h>
#include <linux/fs.h>
#include <linux/fcntl.h>
#include <linux/errno.h>
#include <linux/major.h>
#include <linux/netdevice.h>
#include <linux/firewall.h>
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "random.h"
#include "ipsp.h"
#include "crypt.h"
#include "sign.h"
#include "interface.h"
#include "queue.h"
#include "req.h"
#include "com.h"
#include "device.h"

/* #define DEBUG_LINUX_IOCTL */
/* #define MOD_INC_USE_COUNT */
/* #define MOD_DEC_USE_COUNT */

/* ioctl function -- called from device switching table
   This function copies the arguments from user space, dispatches
   to the req_handle request handler, copies the results to user
   space and returns */
int ioctl_skip(struct inode *inode, struct file *file, 
               unsigned int cmd, unsigned long arg)
{
  struct devioctl *io;
  int retval;
  int newlen = 0;
  u_char *req;

  if (!suser())
    return -EPERM;

  if (cmd != SKIP_DEV_IOCTL)
    return -EINVAL;

  retval = verify_area(VERIFY_WRITE, (void *) arg, sizeof(struct devioctl));
  if (retval)
    return retval;

  io = (struct devioctl *) kmalloc(sizeof(struct devioctl), GFP_ATOMIC);
  if (io == NULL)
    return -ENOMEM;

  memcpy_fromfs(io, (void *) arg, sizeof(struct devioctl));

  retval = verify_area(VERIFY_WRITE, (void *) io->ic_dp, io->ic_len);
  if (retval) {
    kfree(io);
    return retval;
  }
  
  req = (u_char *) kmalloc(io->ic_len, GFP_ATOMIC);
  if (req == NULL) {
    kfree(io);
    return -ENOMEM;
  }

  memcpy_fromfs(req, io->ic_dp, io->ic_len);

#ifdef DEBUG_LINUX_IOCTL
  printk("Calling ioctl request handler, request len=%i\n", io->ic_len);
#endif
  if ((newlen = req_handle(req, io->ic_len)) >= 0) {
#ifdef DEBUG_LINUX_IOCTL
    printk("Request OK, result len=%i\n", newlen);
#endif
    retval = verify_area(VERIFY_WRITE, (void *) io->ic_dp, newlen);
    if (retval) {
      kfree(req);
      kfree(io);
      return retval;
    }
    memcpy_tofs((void *) io->ic_dp, req, newlen);
  }
  io->ic_len = newlen;
  memcpy_tofs((void *) arg, io, sizeof(struct devioctl));

  kfree(req);
  kfree(io);

  return 0;
}

/* open function -- called from device switching table */
int open_skip(struct inode *inode, struct file *file)
{
  if (MINOR(inode->i_rdev) != SKIP_DEV_MINOR)
    return -ENODEV;

  MOD_INC_USE_COUNT;
  return 0;
}

/* close function -- called from device switching table */
void close_skip(struct inode *inode, struct file *file)
{
  MOD_DEC_USE_COUNT;
}

