/*
   Copyright (C) 1996 Robert Muchsel

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Please address all correspondence concerning the software to
   muchsel@acm.org.
*/

#ifndef _ENSKIP_LINUX_INTERFACE_H
#define _ENSKIP_LINUX_INTERFACE_H

#include <linux/firewall.h>

extern int interface_attach(void *, u_char *);
extern int interface_detach(void *, u_char *);
extern int interface_feed_out(struct sk_buff *);
extern int interface_feed_in(struct sk_buff *);

extern int interface_getbuf(struct memblk *, void **, int);

extern int interface_init(void);
extern int interface_exit(void);

extern int packet_nop(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int packet_accept(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int input_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int output_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);
extern int forward_packet(struct firewall_ops *, int pf, struct device *, void *, void *, struct sk_buff **);

#endif /* _ENSKIP_LINUX_INTERFACE_H */
