/*
   Copyright (C) 1996 Robert Muchsel

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   Please address all correspondence concerning the software to
   muchsel@acm.org.
*/

#include "config.h"
#include <linux/sched.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include "timeout.h"

/* #define DEBUG_LINUX_TIMER */

/* Simple emulation of timer functions. I don't think this code has
   to be commented... */

#define DELTA 2*HZ

static struct timerqueue {
  struct timerqueue *next;
  struct timer_list itimer;
} qt = { NULL, {NULL, NULL, 0, 0, NULL}};

typedef void (*tfunc) (unsigned long);

void timeout(void * func, unsigned long arg, unsigned long sec)
{
  struct timerqueue *p = &qt;

#ifdef DEBUG_LINUX_TIMER
  printk("timeout: append %p, arg %lu, sec %lu\n", func, arg, sec);
#endif

  /* append new timer to structure or recycle if possible */
  while ((p->itimer.expires+DELTA > jiffies) && (p->next != NULL)) 
    p = p->next;
  if (p->itimer.expires+DELTA > jiffies) {
    /* Cannot recycle */
#ifdef DEBUG_LINUX_TIMER
    printk("timeout: allocate a new entry\n");
#endif
    p->next = kmalloc(sizeof(struct timerqueue), GFP_ATOMIC);
    p = p->next;
    p->next = NULL;
  }
#ifdef DEBUG_LINUX_TIMER
  else
    printk("timeout: recycle entry\n");
#endif

  /* set timer */  
  p->itimer.expires = jiffies + sec*HZ;
  p->itimer.data = (unsigned long) arg;
  p->itimer.function = (tfunc) func;
  add_timer(&(p->itimer));
}

void untimeout(void * func, unsigned long arg)
{
  struct timerqueue *p = &qt;

#ifdef DEBUG_LINUX_TIMER
  printk("untimeout: delete %p, arg %lu\n", func, arg);
#endif

  /* find timer to structure */
  while ((p->itimer.function != (tfunc) func) &&
         (p->itimer.data != arg) &&
         (p != NULL))
    p = p->next;
  if (p == NULL) {
#ifdef DEBUG_LINUX_TIMER
    printk("untimeout: timer not found\n");
#endif
    return;
  }

  /* clear timer */  
  del_timer(&(p->itimer));
  p->itimer.expires = 0;
  p->itimer.function = (tfunc) 0;
}

void timeout_exit(void)
{
  struct timerqueue *q;
  struct timerqueue *p = qt.next;

  while (p != NULL) {
    if (p->itimer.expires != 0) {
#ifdef DEBUG_LINUX_TIMER
      printk("timeout_exit: timer might still be active, deleting timer\n");
#endif
      del_timer(&(p->itimer));
    }

    q = p->next;
    kfree(p);
    p = q;
  }

  qt.next = NULL;
}

