/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"
#include <sys/param.h>
#include <sys/proc.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/signalvar.h>
#include <netinet/in.h>

#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "interface.h"
#include "com.h"
#include "crypt.h"
#include "req.h"

#ifdef __GNUC__
#ident "$Id: com.c,v 1.7 1996/04/25 15:02:21 cschneid Exp $"
#else
static char rcsid[] = "$Id: com.c,v 1.7 1996/04/25 15:02:21 cschneid Exp $";
#endif

static pid_t daemonpid;

int com_signal(int sig)
{
  if (daemonpid)
  {
    struct proc *proc = pfind(daemonpid);

    if (proc)
      psignal(proc, sig);
    else
      daemonpid = 0;  /* Daemon probably died, don't send any more signals */
  }

  return 0;
}

int com_register(pid_t pid)
{
  daemonpid = pid;

  return 0;
}

int com_skipcall(struct proc *p, struct skipcallparam *uap, int retval[])
{
  int result = EPERM;
  int len, newlen;
  u_char *req;

  if (!suser(p->p_ucred, &p->p_acflag))
  {
    result = EINVAL;

    if (copyin(uap->len, &len, sizeof(len)) == 0)	/* Copy in len */
    {
      result = ENOMEM;

      if ((req = KALLOC(len)))				/* Get buf for req */
      {
        result = EINVAL;

        if (copyin(uap->req, req, len) == 0)		/* Copy in req */
        {
          if ((newlen = req_handle(req, len)) >= 0)	/* Handle req */
          {
            if (copyout(&newlen, uap->len, sizeof(newlen)) == 0)
              result = copyout(req, uap->req, newlen);	/* Copy out req */
          }
        }

        KFREE(req, len);
      }
    }
  }

  return result;
}
