/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>

#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "queue.h"
#include "interface.h"

#ifdef __GNUC__
#ident "$Id: queue.c,v 1.6 1996/04/25 15:02:21 cschneid Exp $"
#else
static char rcsid[] = "$Id: queue.c,v 1.6 1996/04/25 15:02:21 cschneid Exp $";
#endif

/* XXX: Duplicated in interface.c, should be moved to some .h */
struct interface_fbparam
{
  struct ifnet *ifp;
  struct sockaddr_in address;
  struct rtentry *rt;
};

/* Note: Interface and header are always NULL, we just ignore them */
int queue_enqueuein(struct skipcache *c, void *interface, void *header,
                    void *pkt)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  int old;

  old = splimp();
  /* limit reached? */
  if ((q->inq.ifq_maxlen == 0) || (q->inq.ifq_len < q->inq.ifq_maxlen))
  {
    IF_ENQUEUE(&q->inq, (struct mbuf *)pkt);
    result = 0;
  }
  splx(old);

  return result;
}

int queue_enqueueout(struct skipcache *c, void *interface, void *header,
                     void *pkt)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  int old;
  struct mbuf *m;

  MGET(m, M_DONTWAIT, MT_DATA);

  if (m);
  {
    m->m_len = sizeof(struct interface_fbparam);
    MEMCPY(mtod(m, void *), interface, sizeof(struct interface_fbparam));
    m->m_next = pkt;

    old = splimp();
    /* limit reached? */
    if ((q->outq.ifq_maxlen == 0) || (q->outq.ifq_len < q->outq.ifq_maxlen))
    {
      IF_ENQUEUE(&q->outq, m);
      result = 0;
    }
    splx(old);
  }

  return result;
}

int queue_free(void *cptr)
{
  struct skipcache *c = (struct skipcache *)cptr;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;
  int old;

  old = splimp();
  while (q->outq.ifq_head)
  {
    IF_DEQUEUE(&q->outq, m);
    m_freem(m);
  }

  while (q->inq.ifq_head)
  {
    IF_DEQUEUE(&q->inq, m);
    m_freem(m);
  }
  splx(old);

  return 0;
}

int queue_feed(void *cptr)
{
  struct skipcache *c = (struct skipcache *)cptr;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *in, *out;
  int old;

  old = splimp();
  in = q->inq.ifq_head;
  q->inq.ifq_head = q->inq.ifq_tail = NULL;
  q->inq.ifq_len = 0;
  out = q->outq.ifq_head;
  q->outq.ifq_head = q->outq.ifq_tail = NULL;
  q->outq.ifq_len = 0;
  splx(old);

  while (in)
  {
    struct mbuf *next = in->m_nextpkt;
    in->m_nextpkt = NULL;
    interface_infeedback(in);
    in = next;
  };

  while (out)
  {
    struct mbuf *next = out->m_nextpkt;
    out->m_nextpkt = NULL;
    interface_outfeedback(out);
    out = next;
  };

  return 0;
}

int queue_getips(struct skipcache *c, u_char *srcip, u_char *dstip)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  struct mbuf *m;

  MEMZERO(srcip, IPADDRSIZE);
  MEMZERO(dstip, IPADDRSIZE);

  if ((m = q->inq.ifq_head) == NULL)
    m = q->outq.ifq_head;

  if (m)
  {
    struct ip *ip = mtod(m->m_next, struct ip *);

    MEMCPY(srcip, &ip->ip_src, sizeof(ip->ip_src));
    MEMCPY(dstip, &ip->ip_dst, sizeof(ip->ip_dst));
    result = 0;
  }

  return result;
}

int queue_initqueues(struct skipcache *c)
{
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

  q->inq.ifq_maxlen = QUEUESIZE;
  q->outq.ifq_maxlen = QUEUESIZE;
  return 0;
}

int queue_init(void)
{
  return 0;
}

int queue_exit(void)
{
  return 0;
}
