import java.awt.*;

public class DisplayString extends Component {
  FontMetrics fontMetrics;
  String label;
  Dimension preferred = new Dimension();

  /**
   * Initialize it with the size of a "standard" string :-)
   */
public DisplayString() {
  this("XXXXX");
}

  /**
   * Initialize it according to the length of the given
   * string pattern
   */
public DisplayString(String lengthPattern) {
  // Create an own font, if none is set
  if (font == null)
    font = new Font("TimesRoman", Font.PLAIN, 12);
  fontMetrics = getFontMetrics(font);
  height = Dimension.height = fontMetrics.getHeight();
  width  = Dimension.width  = fontMetrics.stringWidth(lengthPattern);
  label = "";
}

  /**
   * Return the preferred size (according to the initialization).
   */
public Dimension preferredSize() {
  return preferred;
}

  /**
   * Set the label
   */
public void setLabel(String l) {
  if (!l.equals(label)) {
    label = l;
    repaint();
  }
}

  /**
   * Return the current label
   */
public String getLabel() {
  return label;
}

  /**
   * Update the field (just calls paint() to do the job)
   */
public void update(Graphics g) {
  paint(g);
}

  /**
   * Draw the current field
   */
public void paint(Graphics g) {
  Dimension d = size();

  // Clear the area
  g.clearRect(0, 0, d.width, d.height);

  g.drawString(label, 0, fontMetrics.getAscent());
}
  
}
