import java.awt.*;
import java.io.IOException;
import java.util.*;
import java.lang.*;

public class Entries extends Frame implements Runnable {
  Hashtable labels = new Hashtable();
  Thread my;
  CheckboxGroup group = new CheckboxGroup();
  int columns = 2;
  InfoFrame info;
  
public Entries() throws IOException {
  init();
}

public Entries(String title) throws IOException {
  super(title);
  init();
}

private void init() throws IOException {
  setLayout(new GridLayout((SkipCacheEntryList.CACHEENTRIES + columns - 1)
                           / columns, columns));
  // Add the Checkboxes and give them a String which might be the largest
  for (int i = 0; i < SkipCacheEntryList.CACHEENTRIES; i++) {
    Checkbox cb = new Checkbox("01-12345678,01-12345678", group, false);
    add(cb);
  }
  pack();
  resize(preferredSize());

  // But don't show the button labels, they were only used for layouting
  removeAll();
  show();

  updateLabels();
  // Start update thread
  my = new Thread(this);
  my.start();
}

  /**
   * Handle the new strings
   */
public synchronized void updateLabels() throws IOException {
  Hashtable entries = new SkipCacheEntryList().cacheEntries();
  boolean needsPack = false;

  // Delete all button labels that are no longer in use
  for (int i = countComponents() - 1; i >= 0; i--) {
    String label = ((Checkbox)getComponent(i)).getLabel();
    if (!"".equals(label)) {
      if (entries.get(label) == null) {
        // It no longer exists
        labels.remove(label);
        remove(getComponent(i));
        needsPack = true;
      }
    }
  }

  /* And now add all the elements we're currently missing
   * and find out whether the currently selected item still exists
   */
  Checkbox current = group.getCurrent();
  String label;
  if (current != null) {
    label = current.getLabel();
  } else {
    label = "";
  }
  boolean found = false;
  Enumeration elements = entries.keys();
  while (elements.hasMoreElements()) {
    String el = (String)elements.nextElement();
    // Is this label already in use?
    if (labels.get(el) == null) {
      Checkbox cb = new Checkbox(el, group, false);
      add(cb);
      labels.put(el, cb);
      needsPack = true;
    }
    // Does ours still exist
    if (label.equals(el))
      found = true;
  }
  if (!found)
    group.setCurrent(null);

  // Do we need to redisplay it (ugly thing!)
  if (needsPack)
    pack();
}

public boolean action(Event evt, Object arg) {
  // The selection most likely has changed, so update the associated info
  updateInfo();
  // We didn't really handle it, so pass it along
  return super.action(evt, arg);
}

  /**
   * Callback for the Info Window
   */
public synchronized void windowWasClosed() {
  // Make sure it won't pop up soon after it was closes
  group.setCurrent(null);
  // Mark it as closed
  info = null;
}
  
  /**
   * Update the detailed info
   */
public synchronized void updateInfo() {
  Checkbox selected = group.getCurrent();
  String text;
  text = "Initializing -- but why so late ? ;-)";
  if (selected != null) {
    if (info != null && !info.holding()) {
      // Try to avoid executing the process if it is holding anyways
      try {
        // Get the new associated information
        text = new SimpleCacheEntry(selected.getLabel()).cacheInfo();
      } catch (IOException e) {
        // Show the error if nothing else is available
        text = e.toString();
      }
    } else if (info != null) {
      text = info.getText();
    }
    // Make sure the window is visible
    if (info == null) 
      info = new InfoFrame(this);
    info.setText(text);
  } else {
    // No information
    text = "No selection";
    // Display only if we already have a window
    if (info != null)
      info.setText(text);
  }
}
  
  /**
   * This handles the timely updates
   */
public void run() {
  while (true) {
    try {
      my.sleep(2000);
    } catch (InterruptedException e) {
      // Do nothing useful!
      System.err.println(e.toString());
    }
    try {
      updateLabels();
      updateInfo();
    } catch (IOException e) {
      // Do nothing useful!
      System.err.println(e.toString());
    }
  }
}
  
public synchronized boolean handleEvent(Event evt) {
  // Handle WM Quit message
  if (evt.id == Event.WINDOW_DESTROY) {
    if (my != null)
      my.stop();
    dispose();
    if (info != null)
      info.dispose();
    return true;
  }
  return super.handleEvent(evt); // be sure to do this!!!
}

}
