import java.awt.*;

public class InfoFrame extends Frame {

  // Whom to notify on destruction
  Entries creator;
  boolean shown = false;
  SmartArea ta = new SmartArea(36, 87);
  Checkbox hold = new Checkbox("Hold");

public InfoFrame(Entries sender) {
  super("Detailed Info");
  creator = sender;
  ta.setEditable(false);
  add("Center", ta);
  Panel p = new Panel();
  add("South", p);
  p.add("West", hold);
}

public boolean holding() {
  return hold.getState();
}
  
public synchronized void setText(String text) {
  if (!holding()) {
    // Mark the data as being current
    hold.setForeground(Color.black);
    ta.setText(text);
  } else {
    // Mark the data as being outdated
    hold.setForeground(Color.red);
  }
  
  if (!shown) {
    shown = true;
    pack();
    resize(preferredSize());
    show();
  }
}

public String getText() {
  return ta.getText();
}

public synchronized boolean handleEvent(Event evt) {
  // Handle WM Quit message
  if (evt.id == Event.WINDOW_DESTROY) {
    creator.windowWasClosed();
    dispose();
    return true;
  }
  return super.handleEvent(evt); // be sure to do this!!!
}

}
  
