import java.awt.*;
import java.util.*;
import java.lang.Long;

public class LineChart extends Canvas {
  int count, used;
  Hashtable last[];
  Hashtable colors;
  Label maxLabel;
  Color bgColor;
  double prevMax;

public LineChart() {
  this(10);
}

public LineChart(int c) {
  count = c;
  last = new Hashtable[count];
}

public synchronized void forgetSamples() {
  // Forget all samples
  for (int i = 0; i < count; i++) {
    last[i] = null;
  }
  // Start again at the beginning
  used = 0;
  repaint();
}

public void setMaxdisplay(Label maxLabel) {
  this.maxLabel = maxLabel;
}

public void setLabelValue(long value) {
  if (maxLabel != null) {
    maxLabel.setText(new Long(value).toString());
  }
}
  
public void setColors(Hashtable c) {
  colors = c;
  repaint();
}

public void setBackground(Color c) {
  super.setBackground(c);
  repaint();
}

public synchronized void addMeasure(Hashtable measure) {
  // System.err.println(measure.toString());
  last[used] = measure;
  used++;
  if (used == count)
    used = 0;
  last[used] = null;
  repaint();
}

  /**
   * Calculates the maximum value over all enabled items in the last array
   */
public synchronized long max() {
  long max = 0; // could also be Long.MIN_VALUE;
  
  Enumeration elements = colors.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    for (int i = 0; i < count; i++) {
      if (last[i] != null) {
	Object val = last[i].get(el);
	if (val instanceof Number) {
	  long l = ((Number)val).longValue();
	  if (l > max)
	    max = l;
	}
      }
    }
  }
  return max;
}
  
public synchronized void paint(Graphics g) {
  Dimension d = size();

  // Clear the area
  g.clearRect(0, 0, d.width, d.height);

  // Ignore a pixel on each side
  d.width -= 2;
  d.height -= 2;

  // We want at least 1 (no negatives, and no zeroes)
  long intMax = max();
  setLabelValue(intMax);
  double curMax = (double)intMax;
  if (curMax < 1)
    curMax = 1;
  // Try to change the display scale only if something leaves the
  // +10/-20% range
  if (curMax > prevMax || curMax < 0.8 * prevMax) {
    prevMax = curMax = 1.1 * (curMax + 1);
  } else {
    // Inside the 10% region: Use the same scale as last time
    curMax = prevMax;
  }

  double scale = (double)d.height / (double)curMax;
  double distance = (double)d.width / (double)count;

  // Draw the lines
  Enumeration elements = colors.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    boolean prevValid = false; // first approximation
    double prev = 0.0; // Initialization just to make the compiler happy

    // Get last value, if any
    if (last[count -1] != null) {
      Object val = last[count - 1].get(el);
      if (val instanceof Number) {
        prev = ((Number)val).doubleValue();
        prevValid = true;
      }
    }

    g.setColor((Color)colors.get(el));
    for (int i = 0; i < count; i++) {
      if (last[i] == null) {
	prevValid = false;
      } else {
	Object val = last[i].get(el);
	// Is there a valid long at the current position?
	if (val instanceof Number) {
	  double cur = ((Number)val).doubleValue();
	  if (prevValid) {
	    // We can draw something!
	    g.drawLine(1 + (int)(i * distance),
                       1 + d.height - (int)(prev * scale),
		       1 + (int)((i + 1) * distance),
                       1 + d.height - (int)(cur * scale));
	  } else {
	    // Just a dot
	    g.drawLine(1 + (int)(i * distance),
                       1 + d.height - (int)(cur * scale),
		       1 + (int)((i + 1) * distance),
                       1 + d.height - (int)(cur * scale));
	  }
	  prevValid = true;
	  prev = cur;
	} else {
	  prevValid = false;
	}
      }
    }
  }
}
  
public void update(Graphics g){
  paint(g); // Inefficient, but hard to code better
}

}
