import java.util.*;

public class MultiParameter extends Parameter {
  Hashtable text2value = new Hashtable(),
    value2text = new Hashtable();
  String none;

public MultiParameter(String nothing, String keys) {
  none = nothing;
  
  StringTokenizer st = new StringTokenizer(keys, "/");
  int value = 1;
  while (st.hasMoreTokens()) {
    Integer objectValue = new Integer(value);
    text2value.put(st.nextToken(), objectValue);
    value2text.put(objectValue, st.nextToken());
    value <<= 1;
  }
}

public String unparse(int value) {
  String s = null;
  while (value != 0) {
    // Strip the lowest bit
    int lessValue = (value - 1) & value;
    // Extract the lowest bit
    int lowestBit = value ^ lessValue;
    // Append it
    if (s == null) {
      s = (String)value2text.get(new Integer(lowestBit));
    } else {
      s += " " + (String)value2text.get(new Integer(lowestBit));
    }
    value = lessValue;
  }
  if (s != null) {
    return s;
  } else {
    return none;
  }
}

public int parse(String text) {
  if (text.equals(none)) {
    return 0;
  } else {
    int value = 0;
    StringTokenizer st = new StringTokenizer(text);
    while (st.hasMoreTokens()) {
      value |= ((Number)value2text.get(st.nextToken())).intValue();
    }
    return value;
  }
}

}
