import java.awt.*;
import java.lang.String;
import java.util.*;

public class MultipleChoice extends Panel implements Parsing {
  Hashtable values = new Hashtable(),
    reverse = new Hashtable(),
    checkboxes = new Hashtable();
  Button selectAll, selectNone;
  String allString, noneString;
  boolean handleFinally = true;

  /**
   * Creates a new MultipleChoice
   */
public MultipleChoice() {
}

  /**
   * Adds a new element with a public name and an 
   * internal value through which it is referenced.
   * Tries to catch all calls to super's add() methods.
   * @param comp The component to be added
   * @param pos The position to add it to
   */
public Component add(Component comp, int pos) {
  if (comp instanceof Checkbox) {
    add(comp, pos, ((Checkbox)comp).getLabel());
  } else {
    throw new IllegalArgumentException("Adding a non-Checkbox without value");
  }
  return comp;
}

  /**
   * Adds a new element with a public name and an
   * internal value through which it is referenced.
   * Tries to catch all calls to super's add() methods.
   * @param comp The component to be added
   * @param pos The position to add it to
   * @param value The value it represents
   */
public Component add(Component comp, int pos, Object value) {
  super.add(comp, pos);
  if (value != null && comp instanceof Checkbox) {
    String label = ((Checkbox)comp).getLabel();
    values.put(label, value);
    reverse.put(value, label);
    checkboxes.put(value, comp);
  }
  return comp;
}

  /**
   * Add a "Select All" buttons
   */
public void addSelectAll(Button b, int pos) {
  add(b, pos, null);
  selectAll = b;
}

  /**
   * Add a "Select None" buttons
   */
public void addSelectNone(Button b, int pos) {
  add(b, pos, null);
  selectNone = b;
}

  /**
   * Tell whether the all/none buttons are handled finally
   */
public void setHandleButtonsFinally(boolean handleFinally) {
  this.handleFinally = handleFinally;
}

  /**
   * Set the state of all Checkboxes to the given state
   */
public synchronized void setAllStatesTo(boolean state) {
  int ncomponents = countComponents();
  Component component[] = getComponents();

  for (int i = 0 ; i < ncomponents ; i++) {
    Component comp = component[i];
    if (comp instanceof Checkbox)
      ((Checkbox)comp).setState(state);
  }
}

  /**
   * Handle some button actions.
   * If handleFinally is false, then the all/none button actions are passed on
   * despite they are handled here.
   */
public boolean action(Event evt, Object arg) {
  if (evt.target == selectAll) {
    setAllStatesTo(true);
    return handleFinally;
  } else if (evt.target == selectNone) {
    setAllStatesTo(false);
    return handleFinally;
  } else {
    return super.action(evt, arg);
  }
}
  
  /**
   * Set the value of the "all" and "none" strings for parsing
   */
public void setAllAndNoneStrings(String all, String none) {
  allString = all;
  noneString = none;
}
  
  /**
   * Set the value from the given string
   */
public void parseFrom(String s) {
  setAllStatesTo(false);

  StringTokenizer st = new StringTokenizer(s);
  while (st.hasMoreTokens()) {
    String t = st.nextToken();
    if (t.equals(allString)) {
      setAllStatesTo(true);
    } else if (t.equals(noneString)) {
      // Don't clear the flags here, just "or" "none" in
    } else {
      ((Checkbox)checkboxes.get(t)).setState(true);
    }
  }
}

  /**
   * Return a parseable string with the current value
   */
public String parseTo() {
  int ncomponents = countComponents();
  Component component[] = getComponents();
  String s = "";
  
  for (int i = 0 ; i < ncomponents ; i++) {
    Component comp = component[i];
    if (comp instanceof Checkbox) {
      if (((Checkbox)comp).getState() == true) {
	if (!s.equals("")) {
	  s += " ";
	}
	s += (String)values.get(((Checkbox)comp).getLabel());
      }
    }
  }
  // Is it still empty?
  if (s.equals("")) {
    return noneString;
  } else {
    return s;
  }
}
  
  /**
   * Return a Hashtable with all currently active elements
   */
public Hashtable activeElements() {
  int ncomponents = countComponents();
  Component component[] = getComponents();
  Hashtable h = new Hashtable();
  
  for (int i = 0 ; i < ncomponents ; i++) {
    Component comp = component[i];
    if (comp instanceof Checkbox) {
      if (((Checkbox)comp).getState() == true) {
	String label = ((Checkbox)comp).getLabel();
	h.put(label, values.get(label));
      }
    }
  }
  return h;
}

  
  /**
   * Return a string identifying this object
   */
protected String paramString() {
  return super.paramString() + ",parse=" + parseTo();
}
  
}
