import java.awt.*;
import java.lang.String;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ParsingChoice extends Choice implements Parsing {
  Hashtable values = new Hashtable(),
    reverse = new Hashtable();

  /**
   * Creates a new ParsingChoice
   */
public ParsingChoice() {
}

  /**
   * Adds a new item with a public name, associated with a value being the same
   * as this name
   * @param item The name being displayed to the user and it's value
   */
public void addItem(String item) {
  addItem(item, item);
}
  
  /**
   * Adds a new item with a public name and a (possibly different)
   * internal value through which it is referenced
   * @param item The name being displayed to the user
   * @param value The value associated with the item
   */
public void addItem(String item, Object value) {
  super.addItem(item);
  values.put(item, value);
  reverse.put(value, item);
}

  /**
   * Get the value of the current selection
   */
public Object getSelectedValue() {
  return values.get(getSelectedItem());
}

  /**
   * Set the selection to the element whose value is item.
   */
public void selectValue(String value) {
  select((String)reverse.get(value));
}

  /**
   * Set the value from the given string
   */
public void parseFrom(String s) {
  StringTokenizer st = new StringTokenizer(s);
  selectValue(st.nextToken());
}

  /**
   * Return a parseable string with the current value
   */
public String parseTo() {
  return (String)getSelectedValue();
}

  /**
   * Return a string identifying this object
   */
protected String paramString() {
  return super.paramString() + ",parse=" + parseTo();
}
  
}
