import java.util.*;

public class RelativeLineChart extends LineChart {
  Hashtable baseMeasure;
  
public RelativeLineChart() {
}

public RelativeLineChart(int c) {
  super(c);
}

  /**
   * Calling this method does the same thing as the parent method, but
   * it only adds the deltas to the previous measure
   */
public synchronized void addMeasure(Hashtable measure) {
  Hashtable deltas = new Hashtable();

  // Build all the diffs I can build (wherever there is a value in
  // baseMeasure and measure
  Enumeration measureKeys = measure.keys();
  while (measureKeys.hasMoreElements()) {
    Object mk = measureKeys.nextElement();
    Object oldValue, newValue = measure.get(mk);
    // Fill in a value if any is available
    if (baseMeasure == null) {
      oldValue = null;
    } else {
      oldValue = baseMeasure.get(mk);
    }
      
    if (newValue instanceof Number) {
      if (oldValue instanceof Number) {
        // They were some longs, so we can add them to our deltas hash
        deltas.put(mk, new Long(((Number)newValue).longValue()
                                - ((Number)oldValue).longValue()));
      } else {
        // No delta value for it, just copy the value we want
        deltas.put(mk, newValue);
      }
    }
  }

  // Now add the deltas instead of the normal values
  super.addMeasure(deltas);
}

public void setBase(Hashtable base) {
  baseMeasure = base;
}

public Hashtable getBase() {
  return baseMeasure;
}
  
}
