import java.lang.*;
import java.io.*;

public class SimpleCacheEntry extends Object implements Runnable {

  /* Could be anything, the bigger the better */
  static final int chunkSize = 8192;
  String text;
  Thread my;
  Process p;
  
public SimpleCacheEntry(String key) throws IOException {
//  System.err.println(key);
  String args[] = new String[2];
  args[0] = "../skipd/skip_dump";
  args[1] = key;
  my = new Thread(this);
  p = Runtime.getRuntime().exec(args);
  // Wait for the process
  //my.start();
  
  InputStream is = p.getInputStream();

  // Read everything into the String
  byte buf[] = new byte[chunkSize];
  text = new String();
  int len = 0;
  try {
    int c;
    while ((c = is.read()) >= 0) {
      /*
      char x[] = new char[1];
      x[0] = (char)c;
      System.err.print(x);
      */
      buf[len++] = (byte)c;
      if (len == chunkSize) {
        text += new String(buf, 0, 0, len);
        len = 0;
      }
    }
  } catch (IOException e) {
    // Do nothing, we have read what we can
  }
  /* Wait for termination of the process (doesn't help against the
   * messages on stderr
   */
  try {
    p.waitFor();
  } catch (InterruptedException e) {
    System.err.println(e.toString());
  }
  // Add whatever remains
  text += new String(buf, 0, 0, len);
}

public String cacheInfo() {
  return text;
}

public static void main(String args[]) throws java.io.IOException {
  System.err.println(args[0]);
  SimpleCacheEntry s = new SimpleCacheEntry(args[0]);
  System.out.println(s.cacheInfo());
}

  /**
   * Try to wait for process death in a separate thread
   */
public void run() {
  try {
    p.waitFor();
  } catch (InterruptedException e) {
  }
}
  
}
