import java.util.*;

public class SingleParameter extends Parameter {
  Hashtable text2value = new Hashtable(),
    value2text = new Hashtable();

  /**
   * Create a new SingleParameter lookup list from the /-separated
   * keys. The values start at 0.
   */
public SingleParameter(String keys) {
  StringTokenizer st = new StringTokenizer(keys, "/");
  int value = 0;
  while (st.hasMoreTokens()) {
    Integer objectValue = new Integer(value);
    text2value.put(st.nextToken(), objectValue);
    value2text.put(objectValue, st.nextToken());
    value++;
  }
}

  /**
   * Return the string to the value
   */
public String unparse(int value) {
  return (String)value2text.get(new Integer(value));
}

  /**
   * Return the value to the string
   */
public int parse(String text) {
  return ((Number)text2value.get(text)).intValue();
}

}
