/**
 * Ask the skip kernel module for a specific cache entry
 *
 * @author Marcel Waldvogel
 */

import java.io.IOException;
import java.util.Hashtable;
import java.util.Enumeration;

public class SkipCacheEntry extends SkipIoctl {
  static final Parameter
    cryptParams  = new SingleParameter("NONE/DES/3DES-3/IDEA/RC2-40/RC4-40/RC4-128/3DES-2/RC2-128/SAFER-SK128/SIMPLE"),
    saidParams   = new MultiParameter("NONE", "CRYPT/AUTH/SEQ/COMP"),
    signParams   = new SingleParameter("NONE/MD5"),
    filterParams = new SingleParameter("NONE/IP/IPSP"),
    enskipParams = new MultiParameter("NONE", "TCP/UDP/ICMP/OTHER"),
    deskipParams = new SingleParameter("NONE/DESKIP"),
    flagParams   = new MultiParameter("NONE", "NO_KEY/TUNNEL/VALID_KEY");

  String id;
  int ttl, maxttl, keyttl;
  int ref;
  int flags;
  String source, dest;
  int inputFilterBefore, outputFilterBefore;
  int inputFilterAfter, outputFilterAfter;
  int inputEnskipMode;
  int enskipKij, enskipCrypt, enskipMAC, enskipComp;
  int bytesKp, maxBytesKp, ttlKp, maxttlKp;
  String enskipAKp, enskipEKp;
  
  
  /**
   * Fill the structure with the current stats
   */
public SkipCacheEntry() throws IOException {
  if (comCacheEntry() < 0)
    throw new IOException("Cannot read Skip cache entry");
}

  /**
    Fills the instance variable with the current stats
   */
private native int comCacheEntry();

  

}
