/**
 * Ask the skip kernel module for its cache statistics
 *
 * @author Marcel Waldvogel
 */

import java.io.IOException;
import java.util.Hashtable;
import java.util.Enumeration;

public class SkipCacheStats extends SkipIoctl {
  public long
    /* Entries */
    entries, inserted, updated, timedOut, removed,
    /* Lookups */
    lookupHits, lookupRequests;
  
  /**
   * Fill the structure with the current stats
   */
public SkipCacheStats() throws IOException {
  if (comCacheStats() < 0)
    throw new IOException("Cannot read Skip cache statistics");
}

  /**
   * Fills the instance variable with the current stats
   */
private native int comCacheStats();

  /**
   * Returns a hashtable containing name/value pairs for all entry statistics
   */
public Hashtable entryValues() {
  Hashtable h = new Hashtable();
  h.put("Used", new Long(entries));
  h.put("Inserted", new Long(inserted));
  h.put("Updated", new Long(updated));
  h.put("Timed Out", new Long(timedOut));
  h.put("Removed", new Long(removed));
  return h;
}

  /**
   * Returns a hashtable containing name/value pairs for all lookup statistics
   */
public Hashtable lookupValues() {
  Hashtable h = new Hashtable();
  h.put("Hits", new Long(lookupHits));
  h.put("Requests", new Long(lookupRequests));
  return h;
}

  /**
   * Returns a hashtable containing all name/value pairs
   */
public Hashtable values() {
  Hashtable h = new Hashtable();
  mergeHashtables(h, entryValues(), "Entries ");
  mergeHashtables(h, lookupValues(), "Lookup ");
  return h;
}
  
}
