import java.awt.*;
import java.lang.String;
import java.io.IOException;

public class SkipConfig extends Frame {
  GridBagConstraints c;
  GridBagLayout gridbag;

public SkipConfig(String s) {
  super(s);
  MenuBar mb = new MenuBar();
  Menu m = new Menu("File");
  m.add("Quit");
  mb.add(m);
  
  Menu m2 = new Menu("Statistics");
  m2.add("Cache Statistics");
  m2.add("Packet Statistics");
  m2.add("Entry Statistics");
  m2.addSeparator();
  m2.add("Cache Entries");
  mb.add(m2);
  setMenuBar(mb);
  if (false) {
    // Currently commented out, since it has no functionality
    gridbag = new GridBagLayout();
    setLayout(gridbag);

    c = new GridBagConstraints();
    c.fill = GridBagConstraints.BOTH;
    //  c.weightx = 1.0;
    // c.weighty = 1.0;

    c.gridx=0;
    c.gridy=GridBagConstraints.RELATIVE;
    c.gridwidth = 1;
    c.gridheight = 1;
    addFilterItems("Input Filter Before");
    addFilterItems("Input Filter After");
    addFilterItems("Output Filter Before");
    addFilterItems("Output Filter After");
    addDeSkipItems("Input EnSkip Mode");
    addDeSkipItems("Input DeSkip Mode");
    addEnSkipItems("Output EnSkip Mode");
    addEnSkipItems("Output DeSkip Mode");
    addCryptAlgsItems("Kp Algorithm");
    addCryptAlgsItems("Kij Algorithm");
    addSaidItems("Output DeSkip policy");
    addSaidItems("Input DeSkip policy");
    addSignItems("MAC Algorithm");
    addFlagItems("Flags");
  } else {
    add("Center", new Button("                               "));
  }
  pack();
  resize(preferredSize());
  show();
}
  
public boolean handleEvent(Event evt) {
  // Handle WM Quit message
  if (evt.id == Event.WINDOW_DESTROY) {
    dispose();
    System.exit(0);
    return true;
  }
  return super.handleEvent(evt); // be sure to do this!!!
}

public boolean action(Event evt, Object arg) {
/*
  // Debugging only
  if (evt.target instanceof Component &&
      ((Component)evt.target).getParent() instanceof MultipleChoice)
    System.out.println(((Component)evt.target).getParent().toString());
  else
    System.out.println(evt.target.toString());
*/
  if (evt.target instanceof Choice) {
    //    System.out.print("Choice: "); System.out.println((String)arg);
    return true;
  } else if (evt.target instanceof MenuItem) {
    //    System.out.print("Menu: "); System.out.println((String)arg);
    if ("Quit".equals(arg)) {
      dispose();
      System.exit(0);
    } else if ("Cache Statistics".equals(arg)) {
      try {
	new CacheStatistics((String)arg);
      } catch (IOException e) {
	// Nothing really useful
	System.out.println(e.toString());
      }
    } else if ("Packet Statistics".equals(arg)) {
      try {
	new PacketStatistics((String)arg);
      } catch (IOException e) {
	// Nothing really useful
	System.out.println(e.toString());
      }
    } else if ("Entry Statistics".equals(arg)) {
      try {
	new EntryStatistics((String)arg);
      } catch (IOException e) {
	// Nothing really useful
	System.out.println(e.toString());
      }
    } else if ("Cache Entries".equals(arg)) {
      try {
	new Entries((String)arg);
      } catch (IOException e) {
	// Nothing really useful
	System.out.println(e.toString());
      }
    }
    return true;
  } else {
  }
  return false;
}

private void addCryptAlgsItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("None", "NONE");
  t.addItem("DES");
  t.addItem("Triple DES (3 rounds)", "3DES-3");
  t.addItem("IDEA");
  t.addItem("RC2 (40 bits)", "RC2-40");
  t.addItem("RC2 (128 bits)", "RC2-128");
  t.addItem("RC4 (40 bits)", "RC4-40");
  t.addItem("RC4 (128 bits)", "RC4-128");
  t.addItem("3DES-2");
  t.addItem("SAFER SK-128", "SAFER-SK128");
  t.addItem("Simple", "SIMPLE");
}

private void addSaidItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("NONE");
  t.addItem("CRYPT");
  t.addItem("AUTH");
  t.addItem("SEQ");
  t.addItem("COMP");
}

private void addSignItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("NONE");
  t.addItem("MD5");
}

private void addFilterItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("NONE");
  t.addItem("IP");
  t.addItem("IPSP");
}

private void addEnSkipItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("NONE");
  t.addItem("TCP");
  t.addItem("UDP");
  t.addItem("ICMP");
  t.addItem("OTHER");
  t.addItem("ALL");
}

private void addDeSkipItems(String title) {
  ParsingChoice t = new ParsingChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.addItem("NONE");
  t.addItem("DESKIP");
}

private void addFlagItems(String title) {
  MultipleChoice t = new MultipleChoice();
  gridbag.setConstraints(t, c);
  add(t);
  t.add(new Checkbox("NONE"), -1);
  t.add(new Checkbox("No Key"), -1, "NO_KEY");
  t.add(new Checkbox("Tunnel"), -1, "TUNNEL");
  t.add(new Checkbox("Valid Key"), -1, "VALID_KEY");
  t.addSelectAll(new Button("All"), -1);
  t.addSelectNone(new Button("None"), -1);
  t.setAllAndNoneStrings("ALL", "NONE");
}
  

public static void main(String args[]) throws java.io.IOException {
  SkipConfig s = new SkipConfig("ENskip configuration");
}

}
